/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.mappers;

import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.mappers.Mapper;
import com.lambelly.lambnes.platform.mappers.Mapper0;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import java.io.IOException;
import org.apache.log4j.Logger;

public class UnromMapper
extends Mapper0
implements Mapper {
    private Integer rawControlByte = null;
    private int[] prgrom = null;
    private Logger logger = Logger.getLogger(UnromMapper.class);

    public UnromMapper(NesCpuMemory cpuMemory, NesPpuMemory ppuMemory) {
        this.setCpuMemory(cpuMemory);
        this.setPpuMemory(ppuMemory);
    }

    @Override
    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException, IOException {
        super.setMemoryFromHexAddress(address, value);
        if (address >= 32768 && address <= 65535) {
            this.logger.info((Object)("write to 0x8000 - 0xFFFF: address: " + address + " value: " + value));
            int pageStartAddress = value * 16384;
            System.arraycopy(this.getPrgrom(), pageStartAddress, this.getCpuMemory().getMemory(), 32768, 16384);
        }
    }

    @Override
    public void setProgramInstructions(int[] programInstructions) {
        this.setPrgrom(programInstructions);
        System.arraycopy(programInstructions, 0, this.getCpuMemory().getMemory(), 32768, 16384);
        System.arraycopy(programInstructions, programInstructions.length - 16384, this.getCpuMemory().getMemory(), 49152, 16384);
    }

    public Integer getRawControlByte() {
        return this.rawControlByte;
    }

    public void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public int[] getPrgrom() {
        return this.prgrom;
    }

    public void setPrgrom(int[] prgrom) {
        this.prgrom = prgrom;
    }
}

