/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.platform.ppu.BackgroundAttribute;
import com.lambelly.lambnes.platform.ppu.NesTile;
import com.lambelly.lambnes.platform.ppu.NesTileAttribute;
import com.lambelly.lambnes.util.BitUtils;
import com.lambelly.lambnes.util.NumberConversionUtils;
import org.apache.commons.lang.ArrayUtils;

public class BackgroundTile
extends NesTile {
    private BackgroundAttribute backgroundAttributes = new BackgroundAttribute();

    public BackgroundTile() {
    }

    public BackgroundTile(int backgroundNumber, int colorHighBit) {
        super(backgroundNumber, colorHighBit);
        this.setAttributes(colorHighBit);
    }

    @Override
    public void refreshAttributes() {
    }

    public BackgroundTile(int backgroundNumber) {
        super(backgroundNumber);
    }

    public BackgroundTile(BackgroundTile background) {
        super(background);
    }

    @Override
    protected void instantiateTile() {
        int[] background = this.getTileByteArray(this.getTileNumber());
        this.setPatternA(ArrayUtils.subarray((int[])background, (int)0, (int)8));
        this.setPatternB(ArrayUtils.subarray((int[])background, (int)8, (int)16));
    }

    @Override
    public int getPixelColorPaletteIndex(int column, int row) {
        int patternABit = BitUtils.isBitSet(this.getPatternA()[row], column) ? 1 : 0;
        int patternBBit = BitUtils.isBitSet(this.getPatternB()[row], column) ? 1 : 0;
        int lowbit = patternBBit << 1 | patternABit;
        int highbit = this.getAttributes().getColorHighBit();
        int color = highbit << 2 | lowbit;
        return color;
    }

    @Override
    public int getNameTableSelectBit() {
        return LambNes.getPlatform().getPpu().getPpuControlRegister().getBackgroundPatternTableAddress();
    }

    @Override
    public String toString() {
        String colorMapString = "";
        int row = 0;
        while (row < 8) {
            colorMapString = String.valueOf(colorMapString) + "\n";
            int col = 0;
            while (col < 8) {
                colorMapString = String.valueOf(colorMapString) + this.getPixelColorPaletteIndex(col, row);
                ++col;
            }
            ++row;
        }
        return "background tile number: " + this.getTileNumber() + "\n" + "patternA: \n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[0], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[1], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[2], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[3], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[4], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[5], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[6], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[7], 8) + "\n" + "patternB: \n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[0], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[1], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[2], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[3], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[4], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[5], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[6], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[7], 8) + "\n" + "\t\tcolor high bit: " + this.getAttributes().getColorHighBit() + "\n" + "\t\tbackground color palette index map: " + colorMapString;
    }

    @Override
    public BackgroundAttribute getAttributes() {
        return this.backgroundAttributes;
    }

    @Override
    public void setAttributes(NesTileAttribute tileAttribute) {
        this.backgroundAttributes = (BackgroundAttribute)tileAttribute;
    }

    @Override
    public void setAttributes(int colorHighBit) {
        this.backgroundAttributes = new BackgroundAttribute(colorHighBit);
    }
}

