/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.platform.ppu.PPUNameTable;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import com.lambelly.lambnes.platform.ppu.SpriteAttribute;
import com.lambelly.lambnes.platform.ppu.SpriteTile;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class NesPpuMemory {
    private Logger logger = Logger.getLogger(NesPpuMemory.class);
    private int[] patternTable0 = new int[4096];
    private int[] patternTable1 = new int[4096];
    private PPUNameTable nameTableA = null;
    private PPUNameTable nameTableB = null;
    private PPUNameTable nameTable0 = null;
    private PPUNameTable nameTable1 = null;
    private PPUNameTable nameTable2 = null;
    private PPUNameTable nameTable3 = null;
    private PaletteColor[] imagePalette = new PaletteColor[]{new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0)};
    private PaletteColor[] spritePalette = new PaletteColor[]{new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0), new PaletteColor(0, 0)};
    public static final int MIRRORING_VERTICAL = 1;
    public static final int MIRRORING_HORIZONTAL = 0;
    private Ines cartridge;
    private SpriteAttribute[] sprRam = new SpriteAttribute[64];
    private SpriteTile[] spriteBuffer = new SpriteTile[64];
    public static final int BACKGROUND_PALETTE_ADDRESS = 16128;
    public static final int SPRITE_PALETTE_ADDRESS = 16144;

    public NesPpuMemory() {
        int i = 0;
        while (i < this.sprRam.length) {
            this.sprRam[i] = new SpriteAttribute();
            ++i;
        }
    }

    public void establishMirroring() {
        if (this.getNameTableA() == null) {
            this.setNameTableA(new PPUNameTable());
            this.setNameTableB(new PPUNameTable());
        }
        if (this.getCartridge().getHeader().isHorizontalMirroring()) {
            this.establishMirroring(0);
        } else if (this.getCartridge().getHeader().isVerticalMirroring()) {
            this.establishMirroring(1);
        }
    }

    public void establishMirroring(int mirroringControl) {
        if (mirroringControl == 0) {
            this.setNameTable0(this.getNameTableA());
            this.setNameTable1(this.getNameTableA());
            this.setNameTable2(this.getNameTableB());
            this.setNameTable3(this.getNameTableB());
        } else {
            this.setNameTable0(this.getNameTableA());
            this.setNameTable1(this.getNameTableB());
            this.setNameTable2(this.getNameTableA());
            this.setNameTable3(this.getNameTableB());
        }
    }

    public NesPpuMemory(int[] patternTiles) {
        this.setPatternTiles(patternTiles);
    }

    public void setPatternTiles(int[] chrRom) {
        if (chrRom.length > 4096) {
            int[] table0 = ArrayUtils.subarray((int[])chrRom, (int)0, (int)4096);
            int[] table1 = ArrayUtils.subarray((int[])chrRom, (int)4096, (int)8193);
            this.setPatternTable0(table0);
            this.setPatternTable1(table1);
        }
    }

    public PPUNameTable getNameTableFromHexAddress(int address) throws IllegalStateException {
        if (address >= 8192 && address <= 9215) {
            return this.getNameTable0();
        }
        if (address >= 9216 && address <= 10239) {
            return this.getNameTable1();
        }
        if (address >= 10240 && address <= 11263) {
            return this.getNameTable2();
        }
        if (address >= 11264 && address <= 12287) {
            return this.getNameTable3();
        }
        if (address >= 12288 && address <= 13311) {
            return this.getNameTable0();
        }
        if (address >= 13312 && address <= 14335) {
            return this.getNameTable1();
        }
        if (address >= 14336 && address <= 15359) {
            return this.getNameTable2();
        }
        if (address >= 15360 && address <= 16383) {
            return this.getNameTable3();
        }
        throw new IllegalStateException("tried to access name table at 0x" + Integer.toHexString(address));
    }

    public int getMemoryFromHexAddress(int address) throws IllegalStateException {
        if (address >= 0 && address <= 4095) {
            return this.getPatternTable0()[address];
        }
        if (address >= 4096 && address <= 8191) {
            int arrayIndex = address - 4096;
            return this.getPatternTable1()[arrayIndex];
        }
        if (address >= 8192 && address <= 9151) {
            return this.getNameTable0().getMemoryFromHexAddress(address);
        }
        if (address >= 9152 && address <= 9215) {
            int arrayIndex = address - 9152;
            return this.getNameTable0().getMemoryFromHexAddress(address);
        }
        if (address >= 9216 && address <= 10175) {
            return this.getNameTable1().getMemoryFromHexAddress(address);
        }
        if (address >= 10176 && address <= 10239) {
            return this.getNameTable1().getMemoryFromHexAddress(address);
        }
        if (address >= 10240 && address <= 11199) {
            return this.getNameTable2().getMemoryFromHexAddress(address);
        }
        if (address >= 11200 && address <= 11263) {
            return this.getNameTable2().getMemoryFromHexAddress(address);
        }
        if (address >= 11264 && address <= 12223) {
            return this.getNameTable3().getMemoryFromHexAddress(address);
        }
        if (address >= 12224 && address <= 12287) {
            return this.getNameTable3().getMemoryFromHexAddress(address);
        }
        if (address >= 12288 && address <= 13247) {
            return this.getNameTable0().getMemoryFromHexAddress(address);
        }
        if (address >= 13248 && address <= 13311) {
            return this.getNameTable0().getMemoryFromHexAddress(address);
        }
        if (address >= 13312 && address <= 14271) {
            return this.getNameTable1().getMemoryFromHexAddress(address);
        }
        if (address >= 14272 && address <= 14335) {
            return this.getNameTable1().getMemoryFromHexAddress(address);
        }
        if (address >= 14336 && address <= 15295) {
            return this.getNameTable2().getMemoryFromHexAddress(address);
        }
        if (address >= 15296 && address <= 15359) {
            return this.getNameTable2().getMemoryFromHexAddress(address);
        }
        if (address >= 15360 && address <= 16127) {
            return this.getNameTable3().getMemoryFromHexAddress(address);
        }
        if (address >= 16128 && address <= 16383) {
            int lowbyte = address & 0xFF;
            int palette = (lowbyte & 0xF0) / 15;
            int index = lowbyte & 0xF;
            int value = 0;
            value = palette % 2 == 0 ? this.getImagePalette()[index].getMasterPaletteIndex() : this.getSpritePalette()[index].getMasterPaletteIndex();
            return value;
        }
        if (address >= 16384 && address <= Short.MAX_VALUE) {
            return this.getMemoryFromHexAddress(address - 16384);
        }
        if (address >= 32768 && address <= 49152) {
            return this.getMemoryFromHexAddress(address - 32768);
        }
        throw new IllegalStateException("tried to access memory address 0x" + Integer.toHexString(address) + " which is not mapped to any data structure");
    }

    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException {
        if (address >= 0 && address <= 4095) {
            this.getPatternTable0()[address] = value;
        } else if (address >= 4096 && address <= 8191) {
            int arrayIndex = address - 4096;
            this.getPatternTable1()[arrayIndex] = value;
        } else if (address >= 8192 && address <= 9215) {
            this.getNameTable0().setMemoryFromHexAddress(address, value);
        } else if (address >= 9216 && address <= 10239) {
            this.getNameTable1().setMemoryFromHexAddress(address, value);
        } else if (address >= 10240 && address <= 11263) {
            this.getNameTable2().setMemoryFromHexAddress(address, value);
        } else if (address >= 11264 && address <= 12287) {
            this.getNameTable3().setMemoryFromHexAddress(address, value);
        } else if (address >= 12288 && address <= 13311) {
            this.getNameTable0().setMemoryFromHexAddress(address, value);
        } else if (address >= 13312 && address <= 14335) {
            this.getNameTable1().setMemoryFromHexAddress(address, value);
        } else if (address >= 14336 && address <= 15359) {
            this.getNameTable2().setMemoryFromHexAddress(address, value);
        } else if (address >= 15360 && address <= 16127) {
            this.getNameTable3().setMemoryFromHexAddress(address, value);
        } else if (address >= 16128 && address <= 16383) {
            int lsb = address & 0xFF;
            int palette = (lsb & 0xF0) / 15 % 2;
            int index = lsb & 0xF;
            if (palette == 0) {
                this.setImagePaletteValue(index, value);
            } else {
                this.setSpritePaletteValue(index, value);
            }
            if (index == 0 || index == 4 || index == 8 || index == 12) {
                if (palette == 0) {
                    this.setSpritePaletteValue(0, value);
                    this.setSpritePaletteValue(4, value);
                    this.setSpritePaletteValue(8, value);
                    this.setSpritePaletteValue(12, value);
                } else {
                    this.setImagePaletteValue(0, value);
                    this.setImagePaletteValue(4, value);
                    this.setImagePaletteValue(8, value);
                    this.setImagePaletteValue(12, value);
                }
            }
        } else if (address >= 16384 && address <= Short.MAX_VALUE) {
            this.setMemoryFromHexAddress(address - 16384, value);
        } else if (address >= 32768 && address <= 49152) {
            this.setMemoryFromHexAddress(address - 32768, value);
        } else {
            throw new IllegalStateException("tried to access memory address 0x" + Integer.toHexString(address) + " which is not mapped to any data structure");
        }
    }

    public int[] getPatternTable0() {
        return this.patternTable0;
    }

    public void setPatternTable0(int[] patternTable0) {
        this.patternTable0 = patternTable0;
    }

    public int[] getPatternTable1() {
        return this.patternTable1;
    }

    public void setPatternTable1(int[] patternTable1) {
        this.patternTable1 = patternTable1;
    }

    public SpriteAttribute[] getSprRam() {
        return this.sprRam;
    }

    public SpriteAttribute getSprRam(int index) {
        return this.sprRam[index];
    }

    public SpriteAttribute getSprRamForSpriteNumber(int spriteNumber) {
        int x = 0;
        SpriteAttribute s = new SpriteAttribute();
        while (spriteNumber != s.getTileIndex() && x < 64) {
            s = this.getSprRam(x);
            ++x;
        }
        if (s.getTileIndex() == spriteNumber) {
            return s;
        }
        return new SpriteAttribute();
    }

    public int getSprRamFromHexAddress(int address) {
        int sprRamIndex = address / 4;
        int sprAttributeIndex = address % 4;
        switch (sprAttributeIndex) {
            case 0: {
                return this.sprRam[sprRamIndex].getyCoordinate();
            }
            case 1: {
                return this.sprRam[sprRamIndex].getTileIndex();
            }
            case 2: {
                return this.sprRam[sprRamIndex].getColorHighBit();
            }
            case 3: {
                return this.sprRam[sprRamIndex].getxCoordinate();
            }
        }
        return 0;
    }

    public void setSprRam(SpriteAttribute[] sprRam) {
        this.sprRam = sprRam;
    }

    public void setSprRamFromHexAddress(int address, int value) {
        int sprRamIndex = address / 4;
        int sprAttributeIndex = address % 4;
        switch (sprAttributeIndex) {
            case 0: {
                this.sprRam[sprRamIndex].setyCoordinate(value);
            }
            case 1: {
                this.sprRam[sprRamIndex].setTileIndex(value);
            }
            case 2: {
                this.sprRam[sprRamIndex].parseSprRam3(value);
            }
            case 3: {
                this.sprRam[sprRamIndex].setxCoordinate(value);
            }
        }
    }

    public PPUNameTable getNameTableA() {
        return this.nameTableA;
    }

    public void setNameTableA(PPUNameTable nameTableA) {
        this.nameTableA = nameTableA;
    }

    public PPUNameTable getNameTableB() {
        return this.nameTableB;
    }

    public void setNameTableB(PPUNameTable nameTableB) {
        this.nameTableB = nameTableB;
    }

    public PaletteColor[] getImagePalette() {
        return this.imagePalette;
    }

    public void setImagePalette(PaletteColor[] imagePalette) {
        this.imagePalette = imagePalette;
    }

    public PaletteColor getImagePaletteColor(int index) {
        return this.imagePalette[index];
    }

    public void setImagePaletteValue(int index, int value) {
        this.getImagePalette()[index] = new PaletteColor(index, value);
    }

    public PaletteColor[] getSpritePalette() {
        return this.spritePalette;
    }

    public void setSpritePalette(PaletteColor[] spritePalette) {
        this.spritePalette = spritePalette;
    }

    public PaletteColor getSpritePaletteColor(int index) {
        return this.spritePalette[index];
    }

    public void setSpritePaletteValue(int index, int value) {
        this.getSpritePalette()[index] = new PaletteColor(index, value);
    }

    public PPUNameTable getNameTable0() {
        return this.nameTable0;
    }

    public void setNameTable0(PPUNameTable nameTable0) {
        this.nameTable0 = nameTable0;
    }

    public PPUNameTable getNameTable1() {
        return this.nameTable1;
    }

    public void setNameTable1(PPUNameTable nameTable1) {
        this.nameTable1 = nameTable1;
    }

    public PPUNameTable getNameTable2() {
        return this.nameTable2;
    }

    public void setNameTable2(PPUNameTable nameTable2) {
        this.nameTable2 = nameTable2;
    }

    public PPUNameTable getNameTable3() {
        return this.nameTable3;
    }

    public void setNameTable3(PPUNameTable nameTable3) {
        this.nameTable3 = nameTable3;
    }

    public SpriteTile getSpriteFromBuffer(int index) {
        return this.spriteBuffer[index];
    }

    public SpriteTile[] getSpriteBuffer() {
        return this.spriteBuffer;
    }

    public int getSpritesInBufferCount() {
        int spriteCount = 0;
        SpriteTile[] spriteTileArray = this.spriteBuffer;
        int n = this.spriteBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            SpriteTile sprite = spriteTileArray[n2];
            if (sprite != null) {
                ++spriteCount;
            }
            ++n2;
        }
        return spriteCount;
    }

    public void setSpriteBuffer(SpriteTile[] spriteBuffer) {
        this.spriteBuffer = spriteBuffer;
    }

    public void setSpriteToBuffer(int index, SpriteTile sprite) {
        this.spriteBuffer[index] = sprite;
    }

    public void clearSpriteBuffer() {
        this.spriteBuffer = new SpriteTile[64];
    }

    public Ines getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Ines cartridge) {
        this.cartridge = cartridge;
    }
}

