/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.platform.ppu.BackgroundAttribute;
import com.lambelly.lambnes.platform.ppu.BackgroundTile;
import com.lambelly.lambnes.platform.ppu.NesTile;
import com.lambelly.lambnes.platform.ppu.SpriteAttribute;
import com.lambelly.lambnes.platform.ppu.SpriteTile;
import org.apache.log4j.Logger;

public class NesTileCache {
    private BackgroundTile[] backgroundTileCache = new BackgroundTile[256];
    private SpriteTile[] spriteTileCache = new SpriteTile[256];
    private Logger logger = Logger.getLogger(NesTileCache.class);

    public NesTileCache() {
        this.loadBackgroundCache();
        this.loadSpriteCache();
    }

    private void loadBackgroundCache() {
        int i = 0;
        while (i < this.backgroundTileCache.length) {
            this.setBackgroundTile(new BackgroundTile(i), i);
            ++i;
        }
    }

    private void loadSpriteCache() {
        int i = 0;
        while (i < this.spriteTileCache.length) {
            this.setSpriteTile(new SpriteTile(i), i);
            ++i;
        }
    }

    public boolean checkForTileStaleness(NesTile tile) {
        int patternTableAddress = tile.getNameTableSelectBit() * 4096 | tile.tileNumber * 16;
        int patternTableBit = LambNes.getPlatform().getPpuMemory().getMemoryFromHexAddress(patternTableAddress);
        return tile.getPatternA()[0] != patternTableBit;
    }

    public BackgroundTile getBackgroundTile(int backgroundTileNumber) {
        return this.backgroundTileCache[backgroundTileNumber];
    }

    public BackgroundTile getBackgroundTile(int backgroundTileNumber, int colorMSB) {
        BackgroundTile bg = this.getBackgroundTile(backgroundTileNumber);
        if (this.checkForTileStaleness(bg)) {
            this.loadBackgroundCache();
            bg = this.getBackgroundTile(backgroundTileNumber);
        }
        bg.setAttributes(new BackgroundAttribute(colorMSB));
        return bg;
    }

    public SpriteTile getSpriteTile(int spriteTileNumber) {
        return this.spriteTileCache[spriteTileNumber];
    }

    public SpriteTile getSpriteTile(int spriteTileNumber, SpriteAttribute spriteAttribute) {
        SpriteTile s = this.spriteTileCache[spriteTileNumber];
        s.setAttributes(spriteAttribute);
        if (this.checkForTileStaleness(s)) {
            this.loadSpriteCache();
            s = this.getSpriteTile(spriteTileNumber, spriteAttribute);
        }
        return this.spriteTileCache[spriteTileNumber];
    }

    private void setBackgroundTile(BackgroundTile bg, int backgroundTileNumber) {
        this.backgroundTileCache[backgroundTileNumber] = bg;
    }

    public BackgroundTile[] getBackgroundTileCache() {
        return this.backgroundTileCache;
    }

    public void setBackgroundTileCache(BackgroundTile[] backgroundTileCache) {
        this.backgroundTileCache = backgroundTileCache;
    }

    private void setSpriteTile(SpriteTile sp, int spriteTileNumber) {
        this.spriteTileCache[spriteTileNumber] = sp;
    }

    public SpriteTile[] getSpriteTileCache() {
        return this.spriteTileCache;
    }

    public void setSpriteTileCache(SpriteTile[] spriteTileCache) {
        this.spriteTileCache = spriteTileCache;
    }
}

