/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.gui.LambNesGui;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ScreenBuffer {
    private int[] screenBuffer = new int[61440];
    private Logger logger = Logger.getLogger(ScreenBuffer.class);

    public void pushBufferToScreen() {
        LambNesGui.getScreen().setImage(this.getBufferedImageFromScreenBuffer());
    }

    private BufferedImage getBufferedImageFromScreenBuffer() {
        BufferedImage image = new BufferedImage(256, 240, 3);
        WritableRaster raster = image.getRaster();
        int[] pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
        System.arraycopy(this.getScreenBuffer(), 0, pixels, 0, this.getScreenBuffer().length);
        return image;
    }

    public void toFile() {
        this.toFile(null);
    }

    public void toFile(String identifier) {
        try {
            Calendar cal = Calendar.getInstance();
            File outputfile = new File(String.valueOf(Long.toString(cal.getTimeInMillis())) + (identifier != null ? identifier : "") + ".png");
            ImageIO.write((RenderedImage)this.getBufferedImageFromScreenBuffer(), "png", outputfile);
        }
        catch (Exception e) {
            this.logger.error((Object)"problem writing screen buffer to file");
        }
    }

    public void setScreenBufferPixel(int arrayIndex, int color) {
        this.screenBuffer[arrayIndex] = color;
    }

    public void setScreenBufferPixel(int horizontal, int vertical, int color) {
        this.screenBuffer[this.coordinatesToArrayIndex((int)horizontal, (int)vertical)] = color;
    }

    public void setScreenBufferPixel(int horizontal, int vertical, PaletteColor color) {
        this.setScreenBufferPixel(horizontal, vertical, color.getMasterPaletteColor().getColorInt());
    }

    public void setScreenBufferTileRow(int horizontalCoord, int verticalCoord, int hFineScrollOffset, int vFineScrollOffset, PaletteColor[] tileRow) {
        int bufferIndexStart = this.coordinatesToArrayIndex(horizontalCoord, verticalCoord);
        int tileRowIndex = 0;
        while (tileRowIndex < tileRow.length) {
            if (horizontalCoord - hFineScrollOffset >= 0 && horizontalCoord - hFineScrollOffset < 256 && verticalCoord - vFineScrollOffset >= 0 && verticalCoord - vFineScrollOffset < 240) {
                this.setScreenBufferPixel(bufferIndexStart + tileRowIndex - hFineScrollOffset, tileRow[tileRowIndex].getMasterPaletteColor().getColorInt());
            }
            ++tileRowIndex;
        }
    }

    private int coordinatesToArrayIndex(int horizontal, int vertical) {
        LambNesGui.getScreen();
        return vertical * 256 + horizontal;
    }

    public int[] getScreenBuffer() {
        return this.screenBuffer;
    }

    public void setScreenBuffer(int[] screenBuffer) {
        this.screenBuffer = screenBuffer;
    }
}

