/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.ppu.NesPpu;
import org.apache.log4j.Logger;

public class PPUScrollRegister {
    public static final int REGISTER_ADDRESS = 8197;
    private static final int CYCLES_PER_EXECUTION = 0;
    private Integer addressLowByte = null;
    private Integer addressHighByte = null;
    private Integer rawControlByte = null;
    private NesPpu ppu;
    private Logger logger = Logger.getLogger(PPUScrollRegister.class);

    private PPUScrollRegister() {
    }

    public int cycle() {
        if (this.getRawControlByte() != null) {
            int flipflop = this.getPpu().getRegisterAddressFlipFlopLatch();
            int loopyT = this.getPpu().getLoopyT();
            int setLoopyT = 0;
            setLoopyT = flipflop == 0 ? loopyT & 0x7FE0 | (this.getRawControlByte() & 0xF8) >> 3 : this.getPpu().getLoopyT() & 0x8C1F | ((this.getRawControlByte() & 7) << 12 | (this.getRawControlByte() & 0xF8) << 2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("write to register 0x2005: " + this.getRawControlByte() + "\n" + "flipflop is " + flipflop + "\n" + "loopyT is: " + loopyT + "\n" + "setting loopyT to: " + setLoopyT + "\n" + "at scanline " + this.getPpu().getScanlineCount() + " screencount: " + this.getPpu().getScreenCount() + " cpu cycle: " + Platform.getCycleCount()));
            }
            if (flipflop == 0) {
                this.getPpu().setLoopyX(this.getRawControlByte() & 7);
                this.getPpu().setLoopyT(setLoopyT);
                this.setRawControlByte(null);
            } else {
                this.getPpu().setLoopyT(setLoopyT);
                this.clear();
            }
        }
        return 0;
    }

    private void clear() {
        this.setAddressLowByte(null);
        this.setAddressHighByte(null);
        this.setRawControlByte(null);
    }

    public String toString() {
        if (this.getRawControlByte() != null) {
            return "0x8197: " + Integer.toBinaryString(this.getRawControlByte());
        }
        return "0x8197: 0";
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getAddressLowByte() {
        return this.addressLowByte;
    }

    private void setAddressLowByte(Integer addressLowByte) {
        this.addressLowByte = addressLowByte;
    }

    private Integer getAddressHighByte() {
        return this.addressHighByte;
    }

    private void setAddressHighByte(Integer addressHighByte) {
        this.addressHighByte = addressHighByte;
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public NesPpu getPpu() {
        return this.ppu;
    }

    public void setPpu(NesPpu ppu) {
        this.ppu = ppu;
    }
}

