/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.registers.PPUSprRamAddressRegister;
import org.apache.log4j.Logger;

public class PPUSpriteDMARegister {
    public static final int REGISTER_ADDRESS = 16404;
    private static final int CYCLES_PER_EXECUTION = 513;
    private Integer rawControlByte = null;
    private Logger logger = Logger.getLogger(PPUSpriteDMARegister.class);
    private NesCpuMemory cpuMemory;
    private NesPpuMemory ppuMemory;
    private PPUSprRamAddressRegister ppuSprRamAddressRegister;

    private PPUSpriteDMARegister() {
    }

    public int cycle() {
        int cyclesPassed = 0;
        if (this.getRawControlByte() != null) {
            cyclesPassed = 513;
            int dmaFromStart = this.getRawControlByte() << 8;
            int dmaToStart = this.getPpuSprRamAddressRegister().getRawControlByte();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("raw control bytes: 0x4014: " + this.getRawControlByte() + " 0x2003: " + this.getPpuSprRamAddressRegister().getRawControlByte()));
                this.logger.debug((Object)("reading from memory: " + Integer.toHexString(this.getRawControlByte())));
                this.logger.debug((Object)("start: " + dmaFromStart));
                this.logger.debug((Object)("pulling dma from: " + Integer.toHexString(dmaFromStart)));
                this.logger.debug((Object)("pulling dma to: " + Integer.toHexString(dmaFromStart + 255)));
                this.logger.debug((Object)("memory at start: " + this.getCpuMemory().getMemoryFromHexAddress(dmaFromStart)));
            }
            int x = 0;
            while (x < 256) {
                int value = this.getCpuMemory().getMemoryFromHexAddress(dmaFromStart + x);
                int address = dmaToStart + x & 0xFF;
                this.getPpuMemory().setSprRamFromHexAddress(address, value);
                ++x;
            }
            if (this.logger.isDebugEnabled()) {
                int i = 0;
                while (i < this.getPpuMemory().getSprRam().length) {
                    this.logger.debug((Object)("spr[" + i + "] : " + this.getPpuMemory().getSprRam()[i]));
                    ++i;
                }
            }
            this.clear();
        }
        return cyclesPassed;
    }

    private void clear() {
        this.setRawControlByte(null);
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public PPUSprRamAddressRegister getPpuSprRamAddressRegister() {
        return this.ppuSprRamAddressRegister;
    }

    public void setPpuSprRamAddressRegister(PPUSprRamAddressRegister ppuSprRamAddressRegister) {
        this.ppuSprRamAddressRegister = ppuSprRamAddressRegister;
    }
}

