/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.platform.ppu.NesPpu;
import org.apache.log4j.Logger;

public class PPUStatusRegister {
    public static final int REGISTER_ADDRESS = 8194;
    private static final int CYCLES_PER_EXECUTION = 0;
    private boolean vblank = false;
    private boolean sprite0Occurance = false;
    private boolean scanlineSpriteCount = false;
    private boolean vramWriteFlag = false;
    private int rawControlByte = 0;
    private Logger logger = Logger.getLogger(PPUStatusRegister.class);
    private NesPpu ppu;

    private PPUStatusRegister() {
    }

    public int cycle() {
        this.setRawControlByte((this.isVblank() ? 1 : 0) << 7 | (this.isSprite0Occurance() ? 1 : 0) << 6 | (this.isScanlineSpriteCount() ? 1 : 0) << 5 | (this.isVramWriteFlag() ? 1 : 0) << 4 | 0xF);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("0x2002: " + this.getRawControlByte() + "\n" + "raw bits: " + Integer.toBinaryString(this.getRawControlByte()) + "\n" + "isVblank(): " + this.isVblank() + "\n" + "isSprite0Occurance(): " + this.isSprite0Occurance() + "\n" + "isScanlineSpriteCount(): " + this.isScanlineSpriteCount() + "\n" + "isVramWriteFlag(): " + this.isVramWriteFlag() + "\n"));
        }
        return 0;
    }

    public int getRegisterValue() {
        int rValue = this.getRawControlByte();
        this.setVblank(false);
        this.getPpu().resetRegisterAddressFlipFlopLatch();
        return rValue;
    }

    public String toString() {
        return "0x8194: " + Integer.toBinaryString(this.getRawControlByte());
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    public boolean isVblank() {
        return this.vblank;
    }

    public void setVblank(boolean vblank) {
        this.vblank = vblank;
    }

    public boolean isSprite0Occurance() {
        return this.sprite0Occurance;
    }

    public void setSprite0Occurance(boolean sprite0Occurance) {
        this.sprite0Occurance = sprite0Occurance;
    }

    public boolean isScanlineSpriteCount() {
        return this.scanlineSpriteCount;
    }

    public void setScanlineSpriteCount(boolean scanlineSpriteCount) {
        this.scanlineSpriteCount = scanlineSpriteCount;
    }

    public boolean isVramWriteFlag() {
        return this.vramWriteFlag;
    }

    public void setVramWriteFlag(boolean vramWriteFlag) {
        this.vramWriteFlag = vramWriteFlag;
    }

    private int getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(int rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public NesPpu getPpu() {
        return this.ppu;
    }

    public void setPpu(NesPpu ppu) {
        this.ppu = ppu;
    }
}

