/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.cartridge.RomLoader;
import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.util.ArrayUtils;
import com.lambelly.lambnes.util.NumberConversionUtils;
import java.io.FileNotFoundException;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class ChrRomTest {
    private Logger logger = Logger.getLogger(ChrRomTest.class);
    private RomLoader rl = null;
    @Autowired
    private Platform platform;
    @Autowired
    private Ines cartridge;
    @Autowired
    private NesPpuMemory ppuMemory;

    @Before
    public void initialize() throws FileNotFoundException {
        this.logger.debug((Object)"loading file");
        this.setRl(new RomLoader("./roms/rom.zip"));
        this.logger.debug((Object)"creating ines");
        this.getCartridge().init(this.getRl().getRomData());
        this.logger.debug((Object)"attempting to set pattern tiles");
        System.out.println(this.getCartridge().getPatternTiles());
        System.out.println(this.getPpuMemory());
        this.getPpuMemory().setPatternTiles(this.getCartridge().getPatternTiles());
    }

    @Test
    public void testData() {
        ArrayUtils.head(this.getPpuMemory().getPatternTable0(), 20);
        ArrayUtils.foot(this.getPpuMemory().getPatternTable0(), 20);
        ArrayUtils.head(this.getPpuMemory().getPatternTable1(), 20);
        ArrayUtils.foot(this.getPpuMemory().getPatternTable1(), 20);
        int line1a = this.getPpuMemory().getPatternTable0()[0];
        int line2a = this.getPpuMemory().getPatternTable0()[1];
        int line3a = this.getPpuMemory().getPatternTable0()[2];
        int line4a = this.getPpuMemory().getPatternTable0()[3];
        int line5a = this.getPpuMemory().getPatternTable0()[4];
        int line6a = this.getPpuMemory().getPatternTable0()[5];
        int line7a = this.getPpuMemory().getPatternTable0()[6];
        int line8a = this.getPpuMemory().getPatternTable0()[7];
        int line1b = this.getPpuMemory().getPatternTable0()[0];
        int line2b = this.getPpuMemory().getPatternTable0()[1];
        int line3b = this.getPpuMemory().getPatternTable0()[2];
        int line4b = this.getPpuMemory().getPatternTable0()[3];
        int line5b = this.getPpuMemory().getPatternTable0()[4];
        int line6b = this.getPpuMemory().getPatternTable0()[5];
        int line7b = this.getPpuMemory().getPatternTable0()[6];
        int line8b = this.getPpuMemory().getPatternTable0()[7];
        this.logger.debug((Object)"a");
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line1a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line2a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line3a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line4a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line5a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line6a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line7a, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line8a, 8));
        this.logger.debug((Object)"b");
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line1b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line2b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line3b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line4b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line5b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line6b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line7b, 8));
        this.logger.debug((Object)NumberConversionUtils.generateBinaryStringWithleadingZeros(line8b, 8));
    }

    public RomLoader getRl() {
        return this.rl;
    }

    public void setRl(RomLoader rl) {
        this.rl = rl;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Ines getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Ines cartridge) {
        this.cartridge = cartridge;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

