/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuANDTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuANDTest.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testANDImmediate() {
        int instruction = 41;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)1L, (long)this.getCpu().getAccumulator());
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getTestUtils().setMemory(32773, 255);
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDZeroPage() {
        int instruction = 37;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)1L, (long)this.getCpu().getAccumulator());
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        int address = this.getCpuMemory().getProgramCounter() + 1;
        this.getTestUtils().setMemory(address, 255);
        this.getTestUtils().performInstruction(instruction, 65535);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDZeroPageXIndexed() {
        int instruction = 53;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(1);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)2L, (long)this.getCpu().getAccumulator());
        this.getCpu().setX(252);
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpu().setX(250);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)143L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDZeroPageXIndexedIndirect() {
        int instruction = 33;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(1);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)2L, (long)this.getCpu().getAccumulator());
        this.getCpu().setX(252);
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpu().setX(250);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)143L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDZeroPageYIndirectIndexed() {
        int instruction = 49;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setY(1);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)2L, (long)this.getCpu().getAccumulator());
        this.getCpu().setY(252);
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpu().setY(250);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)143L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDAbsolute() throws IOException {
        int instruction = 45;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpuMemory().setMemoryFromHexAddress(32769, 254);
        this.getCpuMemory().setMemoryFromHexAddress(32770, 2);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)254L, (long)this.getCpu().getAccumulator());
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpuMemory().setMemoryFromHexAddress(32775, 205);
        this.getCpuMemory().setMemoryFromHexAddress(32776, 205);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)141L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDAbsoluteX() throws IOException {
        int instruction = 61;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(10);
        this.getCpuMemory().setMemoryFromHexAddress(32769, 254);
        this.getCpuMemory().setMemoryFromHexAddress(32770, 2);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)8L, (long)this.getCpu().getAccumulator());
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpuMemory().setMemoryFromHexAddress(32775, 205);
        this.getCpuMemory().setMemoryFromHexAddress(32776, 205);
        this.getCpu().setX(12);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)137L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testANDAbsoluteY() throws IOException {
        int instruction = 57;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setY(10);
        this.getCpuMemory().setMemoryFromHexAddress(32769, 254);
        this.getCpuMemory().setMemoryFromHexAddress(32770, 2);
        this.getTestUtils().performInstruction(instruction, 255);
        Assert.assertEquals((long)8L, (long)this.getCpu().getAccumulator());
        this.getTestUtils().performInstruction(instruction, 0);
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpuMemory().setMemoryFromHexAddress(32775, 205);
        this.getCpuMemory().setMemoryFromHexAddress(32776, 205);
        this.getCpu().setY(12);
        this.getTestUtils().performInstruction(instruction, 143);
        this.logger.debug((Object)Integer.toHexString(this.getCpu().getAccumulator()));
        Assert.assertEquals((long)137L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

