/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuBCCTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuBCCTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testBCC() {
        int instruction = 144;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setCarry(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setCarry(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBCS() {
        int instruction = 176;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setCarry(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setCarry(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBEQ() {
        int instruction = 240;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setZero(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setZero(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBMI() {
        int instruction = 48;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setNegative(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setNegative(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBNE() {
        int instruction = 208;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setZero(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setZero(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBPL() {
        int instruction = 16;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setNegative(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setNegative(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBVC() {
        int instruction = 80;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setOverflow(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setOverflow(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    @Test
    public void testBVS() {
        int instruction = 112;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setOverflow(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        this.getCpu().getFlags().setOverflow(false);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)32773L, (long)this.getCpuMemory().getProgramCounter());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

