/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuCMPTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuCMPTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testImmediate() throws IOException {
        int instruction = 201;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpuMemory().setMemoryFromHexAddress(32769, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpuMemory().setMemoryFromHexAddress(32771, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testZeroPage() throws IOException {
        int instruction = 197;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpuMemory().setMemoryFromHexAddress(1, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpuMemory().setMemoryFromHexAddress(3, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testZeroPageX() throws IOException {
        int instruction = 213;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(2, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpu().setX(3);
        this.getCpuMemory().setMemoryFromHexAddress(6, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testAbsolute() throws IOException {
        int instruction = 205;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpuMemory().setMemoryFromHexAddress(513, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpuMemory().setMemoryFromHexAddress(1284, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testAbsoluteX() throws IOException {
        int instruction = 221;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(514, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpu().setX(3);
        this.getCpuMemory().setMemoryFromHexAddress(1287, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testAbsoluteY() throws IOException {
        int instruction = 217;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpu().setY(1);
        this.getCpuMemory().setMemoryFromHexAddress(514, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpu().setY(3);
        this.getCpuMemory().setMemoryFromHexAddress(1287, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testIndexedIndirect() throws IOException {
        int instruction = 193;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(2, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpu().setX(3);
        this.getCpuMemory().setMemoryFromHexAddress(6, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void testIndirectIndexed() throws IOException {
        int instruction = 209;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setAccumulator(1);
        this.getCpu().setY(1);
        this.getCpuMemory().setMemoryFromHexAddress(514, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setAccumulator(127);
        this.getCpu().setY(3);
        this.getCpuMemory().setMemoryFromHexAddress(1030, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void compareXImmediate() throws IOException {
        int instruction = 224;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(32769, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setX(127);
        this.getCpuMemory().setMemoryFromHexAddress(32771, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void compareXZeroPage() throws IOException {
        int instruction = 228;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(1, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setX(127);
        this.getCpuMemory().setMemoryFromHexAddress(3, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    @Test
    public void compareXAbsolute() throws IOException {
        int instruction = 236;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(1);
        this.getCpuMemory().setMemoryFromHexAddress(513, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        this.getCpu().setX(127);
        this.getCpuMemory().setMemoryFromHexAddress(1284, 128);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

