/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuLSRTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuLSRTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void LSRTest() {
        int value = 255;
        this.logger.debug((Object)("0xFF: " + Integer.toBinaryString(value)));
        this.logger.debug((Object)("after shift: " + Integer.toBinaryString(value >>= 1)));
    }

    @Test
    public void testAccumulator() {
        int instruction = 74;
        this.getCpu().setAccumulator(228);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)114L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getCpu().setAccumulator(155);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)77L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
    }

    @Test
    public void testZeroPage() {
        int instruction = 70;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpuMemory().getMemoryFromHexAddress(3));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
    }

    @Test
    public void testZeroPageX() {
        int instruction = 86;
        this.getCpu().setX(15);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)8L, (long)this.getCpuMemory().getMemoryFromHexAddress(16));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)9L, (long)this.getCpuMemory().getMemoryFromHexAddress(18));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
    }

    @Test
    public void testAbsolute() {
        int instruction = 78;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(513));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)2L, (long)this.getCpuMemory().getMemoryFromHexAddress(1284));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
    }

    @Test
    public void testAbsoluteX() {
        int instruction = 94;
        this.getCpu().setX(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)81L, (long)this.getCpuMemory().getMemoryFromHexAddress(674));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)82L, (long)this.getCpuMemory().getMemoryFromHexAddress(1445));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

