/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.NesMasterPalette;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class PaletteConfigTest {
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(PaletteConfigTest.class);

    @Test
    public void paletteConfig() throws ConfigurationException {
        try {
            XMLConfiguration config = new XMLConfiguration("palette.xml");
            this.logger.debug((Object)config.isEmpty());
            List reds = config.getList("color[@red]");
            Assert.assertEquals((long)64L, (long)reds.size());
            for (String s : reds) {
                this.logger.debug((Object)s);
            }
            String color = config.getString("palette.color(0).[@red]");
            this.logger.debug((Object)color);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    @Test
    public void palette() throws Exception {
        this.getTestUtils().createTestPlatform();
        this.logger.debug((Object)NesMasterPalette.getInstance());
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

