/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.disassembler;

import com.lambelly.lambnes.cartridge.Cartridge;
import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.disassembler.DisassembledLine;
import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.cpu.Instruction;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Disassembler {
    private static Logger logger = Logger.getLogger(Disassembler.class);
    private static Platform platform = null;
    private static Cartridge cartridge = null;

    private static void disassembleRom() {
        logger.debug((Object)"disassembling rom");
        while (true) {
            int instAddress = Disassembler.getPlatform().getCpuMemory().getProgramCounter();
            Instruction curInst = Instruction.get(Disassembler.getPlatform().getCpuMemory().getNextPrgRomByte());
            int address = 0;
            if (curInst != null) {
                if (curInst.getBytes() != 1) {
                    if (curInst.getBytes() == 2) {
                        address = Disassembler.getPlatform().getCpuMemory().getNextPrgRomByte();
                    } else if (curInst.getBytes() == 3) {
                        address = Disassembler.getPlatform().getCpuMemory().getNextPrgRomShort();
                    }
                }
                DisassembledLine line = new DisassembledLine(curInst, address);
                System.out.println("0x" + Integer.toHexString(instAddress) + " -- " + line);
                continue;
            }
            System.out.println("0x" + Integer.toHexString(instAddress) + " -- UNDEFINED");
        }
    }

    public static void main(String[] args) {
        logger.info((Object)"instantiating platform");
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("beans.xml");
        Disassembler.setPlatform((Platform)applicationContext.getBean(Platform.class));
        Disassembler.setCartridge((Cartridge)applicationContext.getBean(Ines.class));
        try {
            if (Disassembler.getCartridge().getCartridgePath() != null) {
                Disassembler.disassembleRom();
            } else {
                System.err.println("no rom was found");
            }
        }
        catch (IllegalStateException ex) {
            logger.error((Object)"illegal state", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            logger.error((Object)"null pointer", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error((Object)"unhandled exception", (Throwable)e);
        }
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static void setPlatform(Platform platform) {
        Disassembler.platform = platform;
    }

    public static Cartridge getCartridge() {
        return cartridge;
    }

    public static void setCartridge(Cartridge cartridge) {
        Disassembler.cartridge = cartridge;
    }
}

