/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class Config {
    private static Logger logger = Logger.getLogger(Config.class);
    private static boolean colorScreen = true;
    private static boolean soundEnabled = false;
    private static String defaultRomLocation = null;
    private static Configuration config = null;

    public Config() throws IOException {
        Config.loadConfig();
    }

    private static void loadConfig() throws IOException {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration("config.properties");
            Config.setColorScreen(config.getBoolean("colorScreen"));
            Config.setDefaultRomLocation(config.getString("defaultRomLocation"));
            Config.setConfig((Configuration)config);
        }
        catch (Exception e) {
            throw new IOException("unable to load config");
        }
    }

    public static Configuration getConfig() throws IOException {
        if (config == null) {
            Config.loadConfig();
        }
        return config;
    }

    public static void setConfig(Configuration config) {
        Config.config = config;
    }

    public static boolean isColorScreen() {
        return colorScreen;
    }

    public static void setColorScreen(boolean colorScreen) {
        Config.colorScreen = colorScreen;
    }

    public static boolean isSoundEnabled() {
        return soundEnabled;
    }

    public static void setSoundEnabled(boolean soundEnabled) {
        Config.soundEnabled = soundEnabled;
    }

    public static String getDefaultRomLocation() {
        return defaultRomLocation;
    }

    public static void setDefaultRomLocation(String defaultRomLocation) {
        Config.defaultRomLocation = defaultRomLocation;
    }
}

