/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform;

import com.lambelly.lambnes.platform.MasterColor;
import com.lambelly.lambnes.platform.MasterPalette;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public class NesMasterPalette
implements MasterPalette {
    private static Logger logger = Logger.getLogger(NesMasterPalette.class);
    private static MasterColor[] paletteColors = new MasterColor[64];
    private static NesMasterPalette instance = null;

    public NesMasterPalette() throws ConfigurationException {
        try {
            XMLConfiguration paletteConfig = new XMLConfiguration("palette.xml");
            List reds = paletteConfig.getList("color[@red]");
            List blues = paletteConfig.getList("color[@blue]");
            List greens = paletteConfig.getList("color[@green]");
            int i = 0;
            while (i < 64) {
                this.setColor(i, new MasterColor((String)reds.get(i), (String)blues.get(i), (String)greens.get(i)));
                ++i;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("palette could not be configured.");
        }
    }

    public String toString() {
        String returnString = "";
        int i = 0;
        while (i < 64) {
            returnString = String.valueOf(returnString) + "color[" + i + "]:\n" + this.getColor(i);
            ++i;
        }
        return returnString;
    }

    public static NesMasterPalette getInstance() {
        if (instance == null) {
            try {
                instance = new NesMasterPalette();
            }
            catch (Exception e) {
                logger.fatal((Object)("boot issue: " + e.getMessage()), (Throwable)e);
            }
        }
        return instance;
    }

    private MasterColor[] getPaletteColors() {
        return paletteColors;
    }

    private void setPaletteColors(MasterColor[] colors) {
        paletteColors = colors;
    }

    @Override
    public MasterColor getColor(int index) {
        return this.getPaletteColors()[index];
    }

    public void setColor(int index, MasterColor color) {
        this.getPaletteColors()[index] = color;
    }
}

