/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.apu;

import com.lambelly.lambnes.platform.apu.AudioProcessingUnit;
import com.lambelly.lambnes.platform.apu.registers.APUControlRegister;
import com.lambelly.lambnes.platform.apu.registers.APUFrameCounterRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1ChannelRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1LengthCounterRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1SweepRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1TimerLowRegister;
import org.apache.log4j.Logger;

public class NesApu
implements AudioProcessingUnit {
    private static final int APU_SAMPLE_RATE = 44100;
    private static final int APU_CYCLES_PER_SAMPLE = 40;
    private APUControlRegister apuControlRegister;
    private APUFrameCounterRegister apuFrameCounterRegister;
    private APUPulse1ChannelRegister apuPulse1ChannelRegister;
    private APUPulse1LengthCounterRegister apuPulse1LengthCounterRegister;
    private APUPulse1SweepRegister apuPulse1SweepRegister;
    private APUPulse1TimerLowRegister apuPulse1TimerLowRegister;
    private Logger logger = Logger.getLogger(NesApu.class);
    private int apuCycle = 0;

    @Override
    public void cycle(int cpuCycleCount) {
        this.doRegisterReadsWrites();
        int cycle = 0;
        while (cycle < cpuCycleCount) {
            if (this.getApuCycle() % 7458 == 0) {
                this.clockFrameCounter();
            }
            int cfr_ignored_0 = this.getApuCycle() % 40;
            this.incrementApuCycle();
            ++cycle;
        }
    }

    private void clockFrameCounter() {
    }

    public void doRegisterReadsWrites() {
        this.getApuControlRegister().cycle();
        this.getApuFrameCounterRegister().cycle();
        this.getApuPulse1ChannelRegister().cycle();
        this.getApuPulse1LengthCounterRegister().cycle();
        this.getApuPulse1SweepRegister().cycle();
        this.getApuPulse1TimerLowRegister().cycle();
    }

    public int getApuCycle() {
        return this.apuCycle;
    }

    public void setApuCycle(int apuCycle) {
        this.apuCycle = apuCycle;
    }

    public void incrementApuCycle() {
        ++this.apuCycle;
    }

    public APUControlRegister getApuControlRegister() {
        return this.apuControlRegister;
    }

    public void setApuControlRegister(APUControlRegister apuControlRegister) {
        this.apuControlRegister = apuControlRegister;
    }

    public APUFrameCounterRegister getApuFrameCounterRegister() {
        return this.apuFrameCounterRegister;
    }

    public void setApuFrameCounterRegister(APUFrameCounterRegister apuFrameCounterRegister) {
        this.apuFrameCounterRegister = apuFrameCounterRegister;
    }

    public APUPulse1ChannelRegister getApuPulse1ChannelRegister() {
        return this.apuPulse1ChannelRegister;
    }

    public void setApuPulse1ChannelRegister(APUPulse1ChannelRegister apuPulse1ChannelRegister) {
        this.apuPulse1ChannelRegister = apuPulse1ChannelRegister;
    }

    public APUPulse1LengthCounterRegister getApuPulse1LengthCounterRegister() {
        return this.apuPulse1LengthCounterRegister;
    }

    public void setApuPulse1LengthCounterRegister(APUPulse1LengthCounterRegister apuPulse1LengthCounterRegister) {
        this.apuPulse1LengthCounterRegister = apuPulse1LengthCounterRegister;
    }

    public APUPulse1SweepRegister getApuPulse1SweepRegister() {
        return this.apuPulse1SweepRegister;
    }

    public void setApuPulse1SweepRegister(APUPulse1SweepRegister apuPulse1SweepRegister) {
        this.apuPulse1SweepRegister = apuPulse1SweepRegister;
    }

    public APUPulse1TimerLowRegister getApuPulse1TimerLowRegister() {
        return this.apuPulse1TimerLowRegister;
    }

    public void setApuPulse1TimerLowRegister(APUPulse1TimerLowRegister apuPulse1TimerLowRegister) {
        this.apuPulse1TimerLowRegister = apuPulse1TimerLowRegister;
    }
}

