/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.apu.registers;

import com.lambelly.lambnes.util.BitUtils;

public class APUFrameCounterRegister {
    public static final int REGISTER_ADDRESS = 16407;
    public static final int SEQUENCER_MODE_4_STEP_SEQUENCE = 0;
    public static final int SEQUENCER_MODE_5_STEP_SEQUENCE = 1;
    private int sequencerMode = 0;
    private boolean interuptInhibitFlag = false;
    private Integer rawControlByte = 0;

    public void cycle() {
        if (this.getRawControlByte() != null) {
            this.parseWrite(this.rawControlByte);
        }
    }

    public void parseWrite(int rawControlByte) {
        this.setSequencerMode(BitUtils.isBitSet(rawControlByte, 7) ? 1 : 0);
        this.setInteruptInhibitFlag(BitUtils.isBitSet(rawControlByte, 6));
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public int getSequencerMode() {
        return this.sequencerMode;
    }

    public void setSequencerMode(int sequencerMode) {
        this.sequencerMode = sequencerMode;
    }

    public boolean isInteruptInhibitFlag() {
        return this.interuptInhibitFlag;
    }

    public void setInteruptInhibitFlag(boolean interuptInhibitFlag) {
        this.interuptInhibitFlag = interuptInhibitFlag;
    }
}

