/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.controllers;

import com.lambelly.lambnes.platform.controllers.NesControllerPorts;
import org.apache.log4j.Logger;

public class ControlRegister1 {
    private Integer rawControlByte = null;
    private Integer firstWrite = null;
    private boolean strobe = false;
    private int strobeCount = 0;
    private NesControllerPorts controllerPorts;
    public static final int REGISTER_ADDRESS = 16406;
    private static Logger logger = Logger.getLogger(ControlRegister1.class);

    private ControlRegister1() {
    }

    public void cycle() {
        if (this.getRawControlByte() != null) {
            if (this.getRawControlByte() == 1) {
                this.setFirstWrite(this.getRawControlByte());
            } else if (this.getRawControlByte() == 0 && this.getFirstWrite() != null && this.getFirstWrite() == 1) {
                this.setStrobe(true);
                this.setStrobeCount(0);
            }
            this.clear();
        }
    }

    private void clear() {
        this.setRawControlByte(null);
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    public int getRegisterValue() {
        int strobeValue = 0;
        if (this.getStrobe() && this.getStrobeCount() < 24) {
            strobeValue = this.getControllerPorts().getPortA().read(this.getStrobeCount());
            this.incrementStrobeCount();
        }
        return strobeValue;
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public boolean getStrobe() {
        return this.strobe;
    }

    public void setStrobe(boolean strobe) {
        this.strobe = strobe;
    }

    public Integer getFirstWrite() {
        return this.firstWrite;
    }

    public void setFirstWrite(Integer firstWrite) {
        this.firstWrite = firstWrite;
    }

    public int getStrobeCount() {
        return this.strobeCount;
    }

    public void setStrobeCount(int strobeCount) {
        this.strobeCount = strobeCount;
    }

    public void incrementStrobeCount() {
        ++this.strobeCount;
    }

    public NesControllerPorts getControllerPorts() {
        return this.controllerPorts;
    }

    public void setControllerPorts(NesControllerPorts controllerPorts) {
        this.controllerPorts = controllerPorts;
    }
}

