/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.mappers;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.mappers.Mapper;
import com.lambelly.lambnes.platform.mappers.Mapper0;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.util.BitUtils;
import com.lambelly.lambnes.util.SavRamIOUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MMC1Mapper
extends Mapper0
implements Mapper {
    private Integer[] bank = new Integer[8];
    private int bankIndex = this.bank.length - 1;
    private int mirroring = 0;
    private int prgRomBankMode = 0;
    private int chrRomBankMode = 0;
    private int[] prgRom = null;
    private int[] prgRam = null;
    private boolean prgRamChipEnabled = false;
    public static final int MIRRORING_ONE_SCREEN_LOWER_BANK = 0;
    public static final int MIRRORING_ONE_SCREEN_UPPER_BANK = 1;
    public static final int MIRRORING_VERTICAL = 2;
    public static final int PRG_ROM_32K_SWITCH = 0;
    public static final int PRG_ROM_16K_0xC000_SWITCH = 2;
    public static final int PRG_ROM_16K_0x8000_SWITCH = 3;
    public static final int CHR_ROM_8k_SWITCH = 0;
    public static final int CHR_ROM_4k_SWITCH = 1;
    public static final int MIRRORING_HORIZONTAL = 3;
    Logger logger = Logger.getLogger(MMC1Mapper.class);

    public MMC1Mapper(NesCpuMemory cpuMemory, NesPpuMemory ppuMemory) {
        this.setCpuMemory(cpuMemory);
        this.setPpuMemory(ppuMemory);
    }

    @Override
    public int getMemoryFromHexAddress(int address) {
        if (address >= 24576 && address <= Short.MAX_VALUE && this.prgRamChipEnabled) {
            int prgRamIndex = address & 0x1FFF;
            return this.getPrgRamValue(prgRamIndex);
        }
        return super.getMemoryFromHexAddress(address);
    }

    @Override
    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException, IOException {
        if (address >= 24576 && address <= Short.MAX_VALUE) {
            if (this.prgRamChipEnabled) {
                int prgRamIndex = address & 0x1FFF;
                this.setPrgRamValue(prgRamIndex, value);
            } else {
                super.setMemoryFromHexAddress(address, value);
            }
        } else if (address >= 0 && address <= Short.MAX_VALUE) {
            super.setMemoryFromHexAddress(address, value);
        }
        if (address >= 32768 && address <= 65535) {
            if (value >> 7 == 1) {
                this.reset();
            } else {
                this.setValueToBank(value &= 1);
                if (this.getBankIndex() == 2) {
                    if (address >= 32768 && address <= 40959) {
                        this.logger.info((Object)("write to register 0: " + this.getValueFromBank()));
                        this.setMirroring(this.getValueFromBank() & 3);
                        this.setPrgRomBankMode((this.getValueFromBank() & 0xC) >> 2);
                        this.setChrRomBankMode((this.getValueFromBank() & 0x10) >> 4);
                    } else if (address >= 40960 && address <= 49151) {
                        if (this.getChrRomBankMode() == 1) {
                            System.arraycopy(this.getPrgRom(), this.getValueFromBank() * 4096, this.getPpuMemory().getPatternTable0(), 0, 4096);
                        } else {
                            this.logger.info((Object)"8k transfer mode - low");
                            int index = this.getValueFromBank() * 4096;
                            System.arraycopy(this.getPrgRom(), index & 1, this.getPpuMemory().getPatternTable0(), 0, 4096);
                            System.arraycopy(this.getPrgRom(), (index & 1) + 4096, this.getPpuMemory().getPatternTable1(), 0, 4096);
                        }
                    } else if (address >= 49152 && address <= 57343) {
                        if (this.getChrRomBankMode() == 1) {
                            System.arraycopy(this.getPrgRom(), this.getValueFromBank() * 4096, this.getPpuMemory().getPatternTable1(), 0, 4096);
                        }
                    } else if (address >= 57344 && address <= 65535) {
                        if (BitUtils.isBitSet(value, 4)) {
                            this.setPrgRamChipEnabled(false);
                        } else {
                            this.setPrgRamChipEnabled(true);
                            if (this.getPrgRam() == null) {
                                if (SavRamIOUtil.savRamExists(LambNes.getCartridge().getCartridgeName())) {
                                    this.logger.info((Object)"save ram does exist");
                                    this.setPrgRam(SavRamIOUtil.readSavRam(LambNes.getCartridge().getCartridgeName()));
                                } else {
                                    this.logger.info((Object)"save ram doesn't exist");
                                    this.setPrgRam(new int[8192]);
                                }
                            }
                        }
                        if (this.getPrgRomBankMode() == 0) {
                            System.arraycopy(this.getPrgRom(), this.getValueFromBank() * 32768, this.getCpuMemory().getMemory(), 32768, 32768);
                        } else if (this.getPrgRomBankMode() == 3) {
                            System.arraycopy(this.getPrgRom(), this.getValueFromBank() * 16384, this.getCpuMemory().getMemory(), 32768, 16384);
                        } else if (this.getPrgRomBankMode() == 2) {
                            System.arraycopy(this.getPrgRom(), this.getValueFromBank() * 16384, this.getCpuMemory(), 49152, 16384);
                        }
                    }
                    this.reset();
                }
            }
        }
    }

    private void reset() {
        this.setPrgRomBankMode(3);
        this.setBankIndex(this.getBank().length - 1);
    }

    @Override
    public void setProgramInstructions(int[] programInstructions) {
        this.setPrgRom(programInstructions);
        System.arraycopy(programInstructions, 0, this.getCpuMemory().getMemory(), 32768, 16384);
        System.arraycopy(programInstructions, programInstructions.length - 16384, this.getCpuMemory().getMemory(), 49152, 16384);
    }

    public void setValueToBank(int value) {
        this.getBank()[this.getBankIndex()] = value;
        this.decrementBankIndex();
    }

    @Override
    public void writeSavRam() throws IOException, FileNotFoundException {
        SavRamIOUtil.writeSavRam(this.getPrgRam(), LambNes.getCartridge().getCartridgeName());
    }

    public String toString() {
        return "bankIndex: " + this.getBankIndex() + "\n" + "mirroring: " + this.getMirroring() + "\n" + "prgRomBankMode: " + this.getPrgRomBankMode() + "\n" + "chrRomBankMode: " + this.getChrRomBankMode() + "\n";
    }

    public int getValueFromBank() {
        return this.getBank()[3] << 4 | this.getBank()[4] << 3 | this.getBank()[5] << 2 | this.getBank()[6] << 1 | this.getBank()[7];
    }

    public Integer[] getBank() {
        return this.bank;
    }

    public void setBank(Integer[] bank) {
        this.bank = bank;
    }

    public void decrementBankIndex() {
        --this.bankIndex;
    }

    public int getBankIndex() {
        return this.bankIndex;
    }

    public void setBankIndex(int bankIndex) {
        this.bankIndex = bankIndex;
    }

    public int getMirroring() {
        return this.mirroring;
    }

    public void setMirroring(int mirroring) {
        this.mirroring = mirroring;
    }

    public int getPrgRomBankMode() {
        return this.prgRomBankMode;
    }

    public void setPrgRomBankMode(int prgRomBankMode) {
        this.prgRomBankMode = prgRomBankMode;
    }

    public int getChrRomBankMode() {
        return this.chrRomBankMode;
    }

    public void setChrRomBankMode(int chrRomBankMode) {
        this.chrRomBankMode = chrRomBankMode;
    }

    public int[] getPrgRom() {
        return this.prgRom;
    }

    public void setPrgRom(int[] prgRom) {
        this.prgRom = prgRom;
    }

    public boolean isPrgRamChipEnabled() {
        return this.prgRamChipEnabled;
    }

    public void setPrgRamChipEnabled(boolean prgRamChipEnabled) {
        this.prgRamChipEnabled = prgRamChipEnabled;
    }

    public int[] getPrgRam() {
        return this.prgRam;
    }

    public int getPrgRamValue(int prgRamIndex) {
        return this.prgRam[prgRamIndex];
    }

    public void setPrgRam(int[] prgRam) {
        this.prgRam = prgRam;
    }

    public void setPrgRamValue(int prgRamIndex, int value) {
        this.prgRam[prgRamIndex] = value;
    }
}

