/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class ArrayUtilTest {
    @Autowired
    private TestUtils testUtils;

    @Test
    public void subarray() {
        int[] programInstructions = this.getTestUtils().createTestIntArray(32768);
        int[] lower = ArrayUtils.subarray((int[])programInstructions, (int)0, (int)16384);
        int[] upper = ArrayUtils.subarray((int[])programInstructions, (int)16384, (int)32769);
        System.out.println("lower: " + lower.length);
        Assert.assertEquals((long)16384L, (long)lower.length);
        Assert.assertEquals((long)16384L, (long)upper.length);
    }

    @Test
    public void bufferArray() {
        int[] original = new int[]{15, -1};
        int[] buffered = com.lambelly.lambnes.util.ArrayUtils.bufferArray(original, 16384, -69);
        Assert.assertEquals((long)16384L, (long)buffered.length);
        Assert.assertEquals((long)-69L, (long)buffered[original.length + 1]);
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

