/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuASLTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuASLTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testAccumulator() {
        int instruction = 10;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)254L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 21);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)42L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 202);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertTrue((this.getCpu().getAccumulator() != 194 ? 1 : 0) != 0);
        Assert.assertEquals((long)148L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testZeroPage() {
        int instruction = 6;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().setMemory(32769, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)254L, (long)this.getCpuMemory().getMemoryFromHexAddress(255));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 21);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)42L, (long)this.getCpuMemory().getMemoryFromHexAddress(21));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32773, 202);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)148L, (long)this.getCpuMemory().getMemoryFromHexAddress(202));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testZeroPageXIndexed() {
        int instruction = 22;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(2);
        this.getTestUtils().setMemory(32769, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)2L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(3);
        this.getTestUtils().setMemory(32771, 21);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)48L, (long)this.getCpuMemory().getMemoryFromHexAddress(24));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(4);
        this.getTestUtils().setMemory(32773, 202);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)156L, (long)this.getCpuMemory().getMemoryFromHexAddress(206));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsolute() {
        int instruction = 14;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().setMemory(32769, 3);
        this.getTestUtils().setMemory(32770, 0);
        this.getTestUtils().setMemory(3, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)254L, (long)this.getCpuMemory().getMemoryFromHexAddress(3));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32772, 6);
        this.getTestUtils().setMemory(32773, 0);
        this.getTestUtils().setMemory(6, 21);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)42L, (long)this.getCpuMemory().getMemoryFromHexAddress(6));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32775, 9);
        this.getTestUtils().setMemory(32776, 0);
        this.getTestUtils().setMemory(9, 202);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)148L, (long)this.getCpuMemory().getMemoryFromHexAddress(9));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsoluteX() {
        int instruction = 30;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().setMemory(32769, 3);
        this.getTestUtils().setMemory(32770, 0);
        this.getCpu().setX(1);
        this.getTestUtils().setMemory(4, 255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)254L, (long)this.getCpuMemory().getMemoryFromHexAddress(4));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(3);
        this.getTestUtils().setMemory(32772, 6);
        this.getTestUtils().setMemory(32773, 0);
        this.getTestUtils().setMemory(9, 21);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)42L, (long)this.getCpuMemory().getMemoryFromHexAddress(9));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(4);
        this.getTestUtils().setMemory(32775, 9);
        this.getTestUtils().setMemory(32776, 0);
        this.getTestUtils().setMemory(13, 202);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)148L, (long)this.getCpuMemory().getMemoryFromHexAddress(13));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

