/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuLDATest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testLdaImmediate() {
        int instruction = 169;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)204L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdaZeroPage() {
        int instruction = 165;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)204L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdaZeroPageX() {
        int instruction = 181;
        this.getCpu().setX(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)162L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(49);
        this.getTestUtils().setMemory(32771, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)253L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdaAbsolute() {
        int instruction = 173;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)4L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public void testLdaAbsoluteX() {
        int instruction = 185;
        this.getCpu().setX(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)162L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction);
        this.getCpu().setX(31);
        Assert.assertEquals((long)35L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdaIndexedIndirect() {
        int instruction = 161;
        this.getCpu().setX(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)162L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(31);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)2L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdaIndirectIndexed() {
        int instruction = 177;
        this.getCpu().setY(1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)2L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setY(31);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)34L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdxImmediate() {
        int instruction = 162;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)206L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdxZeroPage() {
        int instruction = 166;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)206L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdxZeroPageY() {
        int instruction = 182;
        this.getCpu().setY(10);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)11L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)216L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdxAbsolute() {
        int instruction = 174;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)4L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdxAbsoluteY() {
        int instruction = 190;
        this.getCpu().setY(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)162L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)165L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdyImmediate() {
        int instruction = 160;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)206L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdyZeroPage() {
        int instruction = 164;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)206L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdyZeroPageY() {
        int instruction = 180;
        this.getCpu().setX(10);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)11L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)216L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdyAbsolute() {
        int instruction = 172;
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)1L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)4L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testLdyAbsoluteX() {
        int instruction = 188;
        this.getCpu().setX(161);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)162L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 206);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)165L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }
}

