/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuORATest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private TestUtils testUtils;

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testImmediate() {
        int instruction = 9;
        this.getCpu().setAccumulator(255);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(32771, 254);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testZeroPage() {
        int instruction = 5;
        this.getCpu().setAccumulator(206);
        this.getTestUtils().setMemory(32769, 169);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)239L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(3, 254);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testZeroPageX() {
        int instruction = 21;
        this.getCpu().setAccumulator(206);
        this.getTestUtils().setMemory(32769, 169);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)239L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(3, 254);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsolute() {
        int instruction = 13;
        this.getCpu().setAccumulator(78);
        this.getTestUtils().setMemory(513, 189);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setAccumulator(30);
        this.getTestUtils().setMemory(1284, 54);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)62L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsoluteX() {
        int instruction = 29;
        this.getCpu().setAccumulator(78);
        this.getCpu().setX(10);
        this.getTestUtils().setMemory(523, 189);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setAccumulator(30);
        this.getCpu().setX(9);
        this.getTestUtils().setMemory(1293, 54);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)62L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsoluteY() {
        int instruction = 25;
        this.getCpu().setAccumulator(78);
        this.getCpu().setY(10);
        this.getTestUtils().setMemory(523, 189);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setAccumulator(30);
        this.getCpu().setY(9);
        this.getTestUtils().setMemory(1293, 54);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)62L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testIndexedIndirect() {
        int instruction = 1;
        this.getCpu().setAccumulator(78);
        this.getCpu().setX(10);
        this.getTestUtils().setMemory(11, 189);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setAccumulator(30);
        this.getCpu().setX(9);
        this.getTestUtils().setMemory(12, 54);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)62L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testIndirectIndexed() {
        int instruction = 17;
        this.getCpu().setAccumulator(78);
        this.getCpu().setY(10);
        this.getTestUtils().setMemory(523, 189);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setAccumulator(30);
        this.getCpu().setY(9);
        this.getTestUtils().setMemory(1036, 54);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)62L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

