/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuTAXTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuTAXTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testTAX() {
        int instruction = 170;
        this.getCpu().setAccumulator(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testTAY() {
        int instruction = 168;
        this.getCpu().setAccumulator(30);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)30L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testTSX() {
        int instruction = 186;
        this.getCpuMemory().setStackPointer(30);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)30L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testTXA() {
        int instruction = 138;
        this.getCpu().setX(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testTXS() {
        int instruction = 154;
        this.getCpu().setX(174);
        this.getCpu().getFlags().setOverflow(true);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)174L, (long)this.getCpuMemory().getStackPointer());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isOverflow());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testTYA() {
        int instruction = 152;
        this.getCpu().setY(30);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)30L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

