/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.SpriteTile;
import com.lambelly.lambnes.test.utils.TestUtils;
import com.lambelly.lambnes.util.BitUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class SpriteTest {
    @Autowired
    private NesPpuMemory ppuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(SpriteTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void test() {
        this.getPpuMemory().setSprRamFromHexAddress(0, 78);
        this.getPpuMemory().setSprRamFromHexAddress(1, 1);
        this.getPpuMemory().setSprRamFromHexAddress(2, 0);
        this.getPpuMemory().setSprRamFromHexAddress(3, 102);
        SpriteTile s0 = new SpriteTile(0);
        this.logger.debug((Object)s0);
    }

    @Test
    public void attributeTest() {
        int rb = 34;
        int b1 = (BitUtils.isBitSet(rb, 1) ? 1 : 0) << 1;
        int b2 = BitUtils.isBitSet(rb, 0) ? 1 : 0;
        this.logger.debug((Object)("b1: " + b1));
        this.logger.debug((Object)("b2 " + b2));
        int colorMSB = 0;
        colorMSB = (BitUtils.isBitSet(rb, 1) ? 1 : 0) << 1 | (BitUtils.isBitSet(rb, 0) ? 1 : 0);
        Assert.assertEquals((long)2L, (long)colorMSB);
    }

    @Test
    public void horizontalFlipTest() {
        int flip = 7;
        Assert.assertEquals((long)0L, (long)(flip ^ 7));
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

