/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test.utils;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.cartridge.RomLoader;
import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.util.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(locations={"classpath:beans.xml"})
public class TestUtils {
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private NesPpuMemory ppuMemory;
    @Autowired
    private NesCpu cpu;
    private Logger logger = Logger.getLogger(TestUtils.class);

    public int[] createTestIntArray(int size) {
        int[] testArray = new int[size];
        int hexIndex = 0;
        int i = 0;
        while (i < size) {
            testArray[i] = hexIndex++;
            if (hexIndex > 255) {
                hexIndex = 0;
            }
            ++i;
        }
        return testArray;
    }

    public Integer[] createTestIntegerArray(int size) {
        Integer[] testArray = new Integer[size];
        int hexIndex = 0;
        int i = 0;
        while (i < size) {
            testArray[i] = hexIndex;
            if (++hexIndex > 255) {
                hexIndex = 0;
            }
            ++i;
        }
        return testArray;
    }

    public void createTestPlatform() throws Exception {
        this.getCpuMemory().setMemory(this.createTestIntArray(65536));
        this.getCpuMemory().setProgramInstructions(this.createTestIntArray(32768));
        RomLoader rl = new RomLoader("./roms/NEStress.zip");
        Ines cartridge = new Ines(rl);
        ArrayUtils.head(cartridge.getPatternTiles(), 16);
        this.getPpuMemory().setPatternTable0(cartridge.getPatternTiles());
        this.getCpuMemory().resetCounters();
        this.getCpu().getFlags().resetFlags();
        this.getCpu().resetRegisters();
    }

    public void performInstruction(int instruction) {
        try {
            this.setNextMemory(instruction);
            this.cpu.processNextInstruction();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void performInstruction(int instruction, int accumulator) {
        try {
            this.setNextMemory(instruction);
            this.cpu.setAccumulator(accumulator);
            this.cpu.processNextInstruction();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void setNextMemory(int value) {
        try {
            int curPrgAddress = this.cpuMemory.getProgramCounter();
            this.cpuMemory.setMemoryFromHexAddress(curPrgAddress, value);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void setMemory(int address, int value) {
        try {
            this.cpuMemory.setMemoryFromHexAddress(address, value);
        }
        catch (Exception e) {
            this.logger.error((Object)"io error", (Throwable)e);
        }
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }
}

