/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.cartridge;

import com.lambelly.lambnes.util.BitUtils;

public class Header {
    private boolean Nes = false;
    private int programInstructionByte = 0;
    private int patternTileByte = 0;
    private int mapperID = 0;
    private boolean horizontalMirroring = false;
    private boolean verticalMirroring = false;
    private boolean sramEnabled = false;
    private boolean trainerPresent = false;
    private boolean fourScreenMirroring = false;

    public Header(int[] rawData) {
        this.setNes(true);
        this.setProgramInstructionByte(rawData[4]);
        this.setPatternTileByte(rawData[5]);
        this.parseControlByte1(rawData[6]);
        if (rawData[8] == 0 && rawData[9] == 0 && rawData[10] == 0 && rawData[11] == 0 && rawData[12] == 0 && rawData[13] == 0 && rawData[14] == 0 && rawData[15] == 0) {
            this.setMapperID(this.parseMapper(rawData[6], rawData[7]));
        } else {
            this.setMapperID(this.parseMapper(rawData[6]));
        }
    }

    private void parseControlByte1(int control) {
        if (BitUtils.isBitSet(control, 0)) {
            this.setVerticalMirroring(true);
        } else {
            this.setHorizontalMirroring(true);
        }
        this.setSramEnabled(BitUtils.isBitSet(control, 1));
        this.setTrainerPresent(BitUtils.isBitSet(control, 2));
        this.setFourScreenMirroring(BitUtils.isBitSet(control, 3));
    }

    private int parseMapper(int controlBit1) {
        return (controlBit1 & 0xF0) >> 4;
    }

    private int parseMapper(int controlBit1, int controlBit2) {
        return (controlBit1 & 0xF0) >> 4 | controlBit2 & 0xF0;
    }

    public boolean isNes() {
        return this.Nes;
    }

    public void setNes(boolean Nes) {
        this.Nes = Nes;
    }

    public int getProgramInstructionByte() {
        return this.programInstructionByte;
    }

    public void setProgramInstructionByte(int programInstructionByte) {
        this.programInstructionByte = programInstructionByte;
    }

    public int getPatternTileByte() {
        return this.patternTileByte;
    }

    public void setPatternTileByte(int patternTileByte) {
        this.patternTileByte = patternTileByte;
    }

    public boolean isHorizontalMirroring() {
        return this.horizontalMirroring;
    }

    public void setHorizontalMirroring(boolean horizontalMirroring) {
        this.horizontalMirroring = horizontalMirroring;
    }

    public boolean isVerticalMirroring() {
        return this.verticalMirroring;
    }

    public void setVerticalMirroring(boolean verticalMirroring) {
        this.verticalMirroring = verticalMirroring;
    }

    public boolean isSramEnabled() {
        return this.sramEnabled;
    }

    public void setSramEnabled(boolean sramEnabled) {
        this.sramEnabled = sramEnabled;
    }

    public boolean isTrainerPresent() {
        return this.trainerPresent;
    }

    public void setTrainerPresent(boolean trainerPresent) {
        this.trainerPresent = trainerPresent;
    }

    public boolean isFourScreenMirroring() {
        return this.fourScreenMirroring;
    }

    public void setFourScreenMirroring(boolean fourScreenMirroring) {
        this.fourScreenMirroring = fourScreenMirroring;
    }

    public int getMapperID() {
        return this.mapperID;
    }

    public void setMapperID(int mapperID) {
        this.mapperID = mapperID;
    }
}

