/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.cartridge;

import com.lambelly.lambnes.cartridge.Cartridge;
import com.lambelly.lambnes.cartridge.CartridgeLocator;
import com.lambelly.lambnes.cartridge.Header;
import com.lambelly.lambnes.cartridge.RomLoader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class Ines
implements Cartridge {
    private RomLoader romLoader = null;
    private static int[] programInstructions = null;
    private int[] patternTiles = null;
    private Header header = null;
    private String cartridgePath = null;
    private String cartridgeName = null;
    private Logger logger = Logger.getLogger(Ines.class);

    private Ines() {
    }

    public Ines(RomLoader romLoader) {
        this.init(romLoader.getRomData());
    }

    public Ines(String cartridgePath) {
        this.setCartridgePath(cartridgePath);
    }

    public void locateCartidge() throws IOException {
        CartridgeLocator c = null;
        c = this.getCartridgePath() != null ? new CartridgeLocator(this.getCartridgePath()) : new CartridgeLocator();
        File romFile = c.locateCartridge();
        if (romFile != null) {
            this.setCartridgePath(romFile.getAbsolutePath());
        }
        if (this.getCartridgePath() != null) {
            try {
                RomLoader rl = new RomLoader(this.getCartridgePath());
                this.setCartridgeName(rl.getRomName());
                this.init(rl.getRomData());
            }
            catch (Exception e) {
                throw new IOException("unable to open cartridge: " + e.getMessage());
            }
        }
    }

    @Override
    public void init() throws IOException {
        this.locateCartidge();
    }

    @Override
    public void init(int[] rawRomData) {
        this.header = new Header(ArrayUtils.subarray((int[])rawRomData, (int)0, (int)16));
        int programLength = this.determineProgramInstructionLength(this.getHeader().getProgramInstructionByte());
        int patternTileLength = this.determinePatternTileInstructionLength(this.getHeader().getPatternTileByte());
        this.setProgramInstructions(ArrayUtils.subarray((int[])rawRomData, (int)16, (int)(programLength + 16)));
        int[] patternTiles = ArrayUtils.subarray((int[])rawRomData, (int)(16 + programLength), (int)rawRomData.length);
        this.setPatternTiles(patternTiles);
        this.logger.info((Object)("byte 4 (programLength): " + programLength));
        this.logger.info((Object)"getting program from: 0xA");
        this.logger.info((Object)("getting program to: " + Integer.toHexString(programLength + 16)));
        this.logger.info((Object)("getting pattern from: " + (16 + programLength)));
        this.logger.info((Object)("getting pattern to: " + rawRomData.length));
        this.logger.info((Object)("pattern tile length: " + patternTiles.length));
        this.logger.info((Object)("program pages: " + this.getHeader().getProgramInstructionByte()));
        this.logger.info((Object)("chr-rom pages: " + this.getHeader().getPatternTileByte()));
        this.logger.info((Object)("program array length: " + this.getProgramInstructions().length));
        this.logger.info((Object)("pattern array length: " + this.getPatternTiles().length));
    }

    private int determineProgramInstructionLength(int b) {
        return b * 16384;
    }

    private int determinePatternTileInstructionLength(int b) {
        return b * 8192;
    }

    @Override
    public int[] getPage(int pageIndex) {
        int[] page = null;
        System.arraycopy(this.getProgramInstructions(), 0, page, 32768, 16384);
        return page;
    }

    public RomLoader getRomLoader() {
        return this.romLoader;
    }

    @Override
    public void setRomLoader(RomLoader romLoader) {
        this.romLoader = romLoader;
    }

    @Override
    public int[] getProgramInstructions() {
        return programInstructions;
    }

    @Override
    public void setProgramInstructions(int[] programInstructions) {
        Ines.programInstructions = programInstructions;
    }

    @Override
    public int[] getPatternTiles() {
        return this.patternTiles;
    }

    @Override
    public void setPatternTiles(int[] patternTiles) {
        this.patternTiles = patternTiles;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public String getCartridgePath() {
        return this.cartridgePath;
    }

    @Override
    public void setCartridgePath(String cartridgePath) {
        this.cartridgePath = cartridgePath;
    }

    @Override
    public String getCartridgeName() {
        return this.cartridgeName;
    }

    public void setCartridgeName(String cartridgeName) {
        this.cartridgeName = cartridgeName;
    }
}

