/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.cartridge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class RomLoader {
    private String filePath = null;
    private String romName = null;
    private int[] romData = null;
    private Logger logger = Logger.getLogger(RomLoader.class);

    public RomLoader(String filePath) throws FileNotFoundException {
        this.setFilePath(filePath);
        if (new File(filePath) == null) {
            this.logger.error((Object)"unable to find rom");
            throw new FileNotFoundException("unable to locate specified rom: " + filePath);
        }
        this.logger.debug((Object)("loading rom: " + filePath));
        this.loadRom();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadRom() {
        ZipFile file = null;
        int nesCount = 0;
        int[] romData = null;
        try {
            try {
                file = new ZipFile(URLDecoder.decode(this.getFilePath(), "UTF-8"));
                Enumeration<? extends ZipEntry> e = file.entries();
                block11: while (true) {
                    if (!e.hasMoreElements()) return;
                    if (nesCount != 0) {
                        return;
                    }
                    ZipEntry ze = e.nextElement();
                    if (!ze.getName().toLowerCase().endsWith(".nes")) continue;
                    ++nesCount;
                    InputStream in = file.getInputStream(ze);
                    this.setRomName(ze.getName());
                    long size = ze.getSize();
                    romData = new int[(int)size];
                    int i = 0;
                    while (true) {
                        int b;
                        if ((b = in.read()) == -1) {
                            this.logger.debug((Object)("rom array size:" + romData.length));
                            this.logger.debug((Object)("size: " + size));
                            continue block11;
                        }
                        romData[i] = b;
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.logger.fatal((Object)("problem loading file: " + this.getFilePath()), (Throwable)e);
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception e2) {
                        this.logger.error((Object)e2);
                    }
                }
                this.setRomData(romData);
                return;
            }
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
            this.setRomData(romData);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int[] getRomData() {
        return this.romData;
    }

    public void setRomData(int[] romData) {
        this.romData = romData;
    }

    public String getRomName() {
        return this.romName;
    }

    public void setRomName(String romName) {
        this.romName = romName;
    }
}

