/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.gui;

import com.lambelly.lambnes.gui.PaletteLabel;
import com.lambelly.lambnes.platform.MasterColor;
import com.lambelly.lambnes.platform.NesMasterPalette;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PaletteVisualization
extends JPanel {
    private Logger logger = Logger.getLogger(PaletteVisualization.class);
    private int paletteMemoryBaseAddress = 0;
    private PaletteLabel[] paletteLabels = null;
    private NesPpuMemory ppuMemory;
    public static final int SCREEN_HORIZONTAL_RESOLUTION = 256;
    public static final int SCREEN_VERTICAL_RESOLUTION = 240;

    public PaletteVisualization(int paletteMemoryBaseAddress, int paletteSize) {
        super(new GridLayout((int)Math.sqrt(paletteSize), (int)Math.sqrt(paletteSize)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"initializing");
        }
        this.setBounds(0, 0, 256, 240);
        this.setPreferredSize(new Dimension(256, 240));
        this.setToolTipText("sprite palette table");
        this.setPaletteMemoryBaseAddress(paletteMemoryBaseAddress);
        this.setPaletteLabels(new PaletteLabel[paletteSize]);
        int x = 0;
        while (x < paletteSize) {
            PaletteLabel pl = new PaletteLabel(NesMasterPalette.getInstance().getColor(0));
            this.setPaletteLabel(x, pl);
            this.add(pl);
            ++x;
        }
        this.refreshPalette();
    }

    public void refreshPalette() {
        int x = 0;
        while (x < this.getPaletteLabels().length) {
            int masterPaletteIndex = this.getPpuMemory().getMemoryFromHexAddress(this.getPaletteMemoryBaseAddress() + x);
            MasterColor p = NesMasterPalette.getInstance().getColor(masterPaletteIndex);
            this.getPaletteLabel(x).refreshBackground(p);
            ++x;
        }
    }

    public int getPaletteMemoryBaseAddress() {
        return this.paletteMemoryBaseAddress;
    }

    public void setPaletteMemoryBaseAddress(int paletteMemoryBaseAddress) {
        this.paletteMemoryBaseAddress = paletteMemoryBaseAddress;
    }

    public PaletteLabel[] getPaletteLabels() {
        return this.paletteLabels;
    }

    public PaletteLabel getPaletteLabel(int index) {
        return this.paletteLabels[index];
    }

    public void setPaletteLabels(PaletteLabel[] paletteLabels) {
        this.paletteLabels = paletteLabels;
    }

    public void setPaletteLabel(int index, PaletteLabel paletteLabel) {
        this.paletteLabels[index] = paletteLabel;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

