/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.platform.apu.NesApu;
import com.lambelly.lambnes.platform.controllers.NesControllerPorts;
import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.interrupts.InterruptRequest;
import com.lambelly.lambnes.platform.interrupts.NesInterrupts;
import com.lambelly.lambnes.platform.mappers.MMC1Mapper;
import com.lambelly.lambnes.platform.mappers.MMC3Mapper;
import com.lambelly.lambnes.platform.mappers.UnromMapper;
import com.lambelly.lambnes.platform.ppu.NesPpu;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Platform {
    private boolean run = true;
    private static Logger logger = Logger.getLogger(Platform.class);
    public static final int CPU_FREQUENCY = Double.valueOf(1789000.0).intValue();
    public static final int EIGHT_BIT_MASK = 255;
    public static final int SIXTEEN_BIT_MASK = 65535;
    private static long cycleCount = 0L;
    private static long frameCycle = 0L;
    private static long frameStartTime = 0L;
    private static int frameCount = 0;
    long startTime = System.nanoTime();
    long previousCycles = 0L;
    private NesCpu cpu;
    private NesApu apu;
    private NesCpuMemory cpuMemory;
    private NesPpu ppu;
    private NesPpuMemory ppuMemory;
    private NesInterrupts interrupts;
    private NesControllerPorts controllerPorts;
    private Ines cartridge;

    private Platform() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws IOException {
        logger.info((Object)"platform init");
        if (this.getCartridge() == null) throw new IllegalStateException("no cartridge inserted");
        if (this.getCartridge().getHeader().getMapperID() != 0) {
            if (this.getCartridge().getHeader().getMapperID() == 1) {
                this.getCpuMemory().setMapper(new MMC1Mapper(this.getCpuMemory(), this.getPpuMemory()));
            } else if (this.getCartridge().getHeader().getMapperID() == 2) {
                this.getCpuMemory().setMapper(new UnromMapper(this.getCpuMemory(), this.getPpuMemory()));
            } else if (this.getCartridge().getHeader().getMapperID() == 3) {
                this.getCpuMemory().setMapper(new UnromMapper(this.getCpuMemory(), this.getPpuMemory()));
            } else {
                if (this.getCartridge().getHeader().getMapperID() != 4) throw new IllegalStateException("cartridge utilizes currently unsupported mapper: " + this.getCartridge().getHeader().getMapperID());
                logger.info((Object)"using mapper MMC3");
                this.getCpuMemory().setMapper(new MMC3Mapper(this.getCpuMemory(), this.getPpuMemory()));
            }
        }
        this.getPpuMemory().establishMirroring();
        this.getCpuMemory().init(this.getCartridge().getProgramInstructions(), this.getCartridge().getPatternTiles());
        this.getInterrupts().init();
        this.getInterrupts().addInterruptRequestToQueue(new InterruptRequest(2));
        this.getInterrupts().cycle();
    }

    public void power() throws IOException, InterruptedException {
        this.init();
        Platform.setFrameStartTime(System.currentTimeMillis());
        while (this.isRun()) {
            int cyclesPassed = 0;
            cyclesPassed += this.getCpu().processNextInstruction();
            this.getPpu().cycle(cyclesPassed += this.getInterrupts().cycle());
            this.getApu().cycle(cyclesPassed);
            this.getControllerPorts().cycle();
            Platform.addToCycleCount(cyclesPassed);
            Platform.addToFrameCycle(cyclesPassed);
            if (Platform.getFrameCycle() < 29606L) continue;
            long sleepyTime = 16L - (System.currentTimeMillis() - Platform.getFrameStartTime());
            if (sleepyTime > 0L) {
                Thread.currentThread();
                Thread.sleep(sleepyTime);
            }
            Platform.setFrameStartTime(System.currentTimeMillis());
            Platform.resetFrameCycle();
        }
    }

    public static long getFrameStartTime() {
        return frameStartTime;
    }

    public static void setFrameStartTime(long frameStartTime) {
        Platform.frameStartTime = frameStartTime;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public static long getCycleCount() {
        return cycleCount;
    }

    private static void setCycleCount(long cycleCount) {
        Platform.cycleCount = cycleCount;
    }

    private static void addToCycleCount(int cycleCount) {
        Platform.cycleCount += (long)cycleCount;
    }

    private static void incrementCycleCount() {
        ++cycleCount;
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesInterrupts getInterrupts() {
        return this.interrupts;
    }

    public void setInterrupts(NesInterrupts interrupts) {
        this.interrupts = interrupts;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        logger.info((Object)("mapper null: " + cpuMemory.getMapper() == null ? 1 : 0));
        this.cpuMemory = cpuMemory;
    }

    public Ines getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Ines cartridge) {
        this.cartridge = cartridge;
    }

    public NesPpu getPpu() {
        return this.ppu;
    }

    public void setPpu(NesPpu ppu) {
        this.ppu = ppu;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public NesApu getApu() {
        return this.apu;
    }

    public void setApu(NesApu apu) {
        this.apu = apu;
    }

    public NesControllerPorts getControllerPorts() {
        return this.controllerPorts;
    }

    public void setControllerPorts(NesControllerPorts controllerPorts) {
        this.controllerPorts = controllerPorts;
    }

    public static long getFrameCycle() {
        return frameCycle;
    }

    public static void setFrameCycle(long frameCycle) {
        Platform.frameCycle = frameCycle;
    }

    public static void addToFrameCycle(int cycles) {
        frameCycle += (long)cycles;
    }

    public static void resetFrameCycle() {
        frameCycle = 0L;
    }
}

