/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.apu.registers;

import com.lambelly.lambnes.platform.apu.registers.APUControlRegister;
import com.lambelly.lambnes.util.BitUtils;
import org.apache.log4j.Logger;

public class APUPulse1LengthCounterRegister {
    public static final int REGISTER_ADDRESS = 16387;
    public static final int[] LENGTH_ARRAY_0 = new int[]{10, 20, 40, 80, 160, 60, 14, 26, 12, 24, 48, 96, 192, 72, 16, 32};
    public static final int[] LENGTH_ARRAY_1 = new int[]{254, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30};
    private Integer rawControlByte = null;
    private int lengthCounter = 0;
    private int timerHigh = 0;
    private APUControlRegister apuControlRegister;
    private Logger logger = Logger.getLogger(APUPulse1LengthCounterRegister.class);

    private APUPulse1LengthCounterRegister() {
    }

    public int cycle() {
        if (this.getRawControlByte() != null) {
            this.parseWrite(this.getRawControlByte());
        } else if (this.getLengthCounter() > 0) {
            if (this.getApuControlRegister().isPulse1LengthCounterEnabledFlag()) {
                this.decrementLengthCounter();
            }
        } else {
            this.getApuControlRegister().setPulse1LengthCounterNonZero(true);
        }
        return 0;
    }

    private void parseWrite(int rawControlByte) {
        this.getApuControlRegister().setPulse1LengthCounterNonZero(false);
        int lengthIndex = (this.getRawControlByte() & 0xF0) >> 4;
        if (BitUtils.isBitSet(this.getRawControlByte(), 3)) {
            this.setLengthCounter(LENGTH_ARRAY_1[lengthIndex]);
        } else {
            this.setLengthCounter(LENGTH_ARRAY_0[lengthIndex]);
        }
        this.setTimerHigh(rawControlByte & 7);
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public int getLengthCounter() {
        return this.lengthCounter;
    }

    public void setLengthCounter(int lengthCounter) {
        this.lengthCounter = lengthCounter;
    }

    private void decrementLengthCounter() {
        --this.lengthCounter;
    }

    public int getTimerHigh() {
        return this.timerHigh;
    }

    public void setTimerHigh(int timerHigh) {
        this.timerHigh = timerHigh;
    }

    public APUControlRegister getApuControlRegister() {
        return this.apuControlRegister;
    }

    public void setApuControlRegister(APUControlRegister apuControlRegister) {
        this.apuControlRegister = apuControlRegister;
    }
}

