/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.cpu;

import com.lambelly.lambnes.platform.apu.registers.APUControlRegister;
import com.lambelly.lambnes.platform.apu.registers.APUFrameCounterRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1ChannelRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1LengthCounterRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1SweepRegister;
import com.lambelly.lambnes.platform.apu.registers.APUPulse1TimerLowRegister;
import com.lambelly.lambnes.platform.controllers.ControlRegister1;
import com.lambelly.lambnes.platform.controllers.ControlRegister2;
import com.lambelly.lambnes.platform.mappers.Mapper;
import com.lambelly.lambnes.platform.ppu.registers.PPUControlRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUMaskRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUScrollRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSprRamAddressRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSprRamIORegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSpriteDMARegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUStatusRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUVramAddressRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUVramIORegister;
import com.lambelly.lambnes.util.BitUtils;
import com.lambelly.lambnes.util.NumberConversionUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NesCpuMemory {
    private int stackPointer = 0;
    private int programCounter = 32768;
    private int[] memory = new int[65536];
    public static final int STACK_BASE = 256;
    public static final int STACK_MAX = 511;
    public static final int PRG_ROM_BASE = 32768;
    public static final int NMI_VECTOR = 65530;
    public static final int RESET_VECTOR = 65532;
    public static final int IRQBRK_VECTOR = 65534;
    private PPUSprRamIORegister ppuSprRamIORegister;
    private PPUSprRamAddressRegister ppuSprRamAddressRegister;
    private PPUControlRegister ppuControlRegister;
    private PPUStatusRegister ppuStatusRegister;
    private PPUVramAddressRegister ppuVramAddressRegister;
    private PPUVramIORegister ppuVramIORegister;
    private PPUScrollRegister ppuScrollRegister;
    private PPUSpriteDMARegister ppuSpriteDmaRegister;
    private PPUMaskRegister ppuMaskRegister;
    private APUControlRegister apuControlRegister;
    private APUFrameCounterRegister apuFrameCounterRegister;
    private APUPulse1ChannelRegister apuPulse1ChannelRegister;
    private APUPulse1LengthCounterRegister apuPulse1LengthCounterRegister;
    private APUPulse1SweepRegister apuPulse1SweepRegister;
    private APUPulse1TimerLowRegister apuPulse1TimerLowRegister;
    private ControlRegister1 controlRegister1;
    private ControlRegister2 controlRegister2;
    private Mapper mapper;
    private static Logger logger = Logger.getLogger(NesCpuMemory.class);

    public void init(int[] programInstructions, int[] chrRom) {
        this.setProgramInstructions(programInstructions);
        this.setChrRom(chrRom);
    }

    public int getPrgRomByte(int address) {
        return this.getMemory()[address];
    }

    public int getNextPrgRomByte() {
        return this.getNextPrgRom();
    }

    public int getNextPrgRomShort() {
        int lowerBit = this.getNextPrgRom();
        return BitUtils.unsplitAddress(this.getNextPrgRom(), lowerBit);
    }

    private int getNextPrgRom() {
        int b = 0;
        b = this.getMemoryFromHexAddress(this.getProgramCounter());
        this.incrementProgramCounter();
        return b;
    }

    public int getMemoryFromHexAddress(int address) throws IllegalStateException {
        return this.getMapper().getMemoryFromHexAddress(address);
    }

    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException, IOException {
        this.getMapper().setMemoryFromHexAddress(address, value);
    }

    public void setProgramInstructions(int[] programInstructions) {
        this.getMapper().setProgramInstructions(programInstructions);
    }

    public void setChrRom(int[] chrRom) {
        this.getMapper().setChrRom(chrRom);
    }

    public void resetCounters() {
        this.setProgramCounter(32768);
        this.setStackPointer(0);
    }

    public void pushStack(int value) throws IOException {
        if (Integer.bitCount(value) > 8) {
            throw new IllegalStateException("tried to push non-8 bit digit on stack: 0x" + Integer.toHexString(value));
        }
        int stackPointer = this.getStackPointer();
        int address = Integer.parseInt("01" + NumberConversionUtils.generateHexStringWithleadingZeros(stackPointer, 2), 16);
        this.setMemoryFromHexAddress(address, value);
        --stackPointer;
        this.setStackPointer(stackPointer &= 0xFF);
    }

    public int popStack() {
        int stackPointer = this.getStackPointer();
        ++stackPointer;
        int value = this.getMemoryFromHexAddress(Integer.parseInt("01" + NumberConversionUtils.generateHexStringWithleadingZeros(stackPointer &= 0xFF, 2), 16));
        this.setStackPointer(stackPointer);
        return value;
    }

    public int getStackPointer() {
        return this.stackPointer;
    }

    public void setStackPointer(int stackPointer) {
        this.stackPointer = stackPointer;
    }

    public int getProgramCounter() {
        return this.programCounter;
    }

    public void setProgramCounter(int programCounter) {
        this.programCounter = programCounter;
    }

    public void incrementProgramCounter() {
        this.setProgramCounter(++this.programCounter);
    }

    public int[] getMemory() {
        return this.memory;
    }

    public void setMemory(int[] memory) {
        this.memory = memory;
    }

    public PPUSprRamIORegister getPpuSprRamIORegister() {
        return this.ppuSprRamIORegister;
    }

    public void setPpuSprRamIORegister(PPUSprRamIORegister ppuSprRamIORegister) {
        this.ppuSprRamIORegister = ppuSprRamIORegister;
    }

    public PPUControlRegister getPpuControlRegister() {
        return this.ppuControlRegister;
    }

    public void setPpuControlRegister(PPUControlRegister ppuControlRegister) {
        this.ppuControlRegister = ppuControlRegister;
    }

    public PPUStatusRegister getPpuStatusRegister() {
        return this.ppuStatusRegister;
    }

    public void setPpuStatusRegister(PPUStatusRegister ppuStatusRegister) {
        this.ppuStatusRegister = ppuStatusRegister;
    }

    public PPUVramAddressRegister getPpuVramAddressRegister() {
        return this.ppuVramAddressRegister;
    }

    public void setPpuVramAddressRegister(PPUVramAddressRegister ppuVramAddressRegister) {
        this.ppuVramAddressRegister = ppuVramAddressRegister;
    }

    public PPUVramIORegister getPpuVramIORegister() {
        return this.ppuVramIORegister;
    }

    public void setPpuVramIORegister(PPUVramIORegister ppuVramIORegister) {
        this.ppuVramIORegister = ppuVramIORegister;
    }

    public PPUScrollRegister getPpuScrollRegister() {
        return this.ppuScrollRegister;
    }

    public void setPpuScrollRegister(PPUScrollRegister ppuScrollRegister) {
        this.ppuScrollRegister = ppuScrollRegister;
    }

    public PPUSprRamAddressRegister getPpuSprRamAddressRegister() {
        return this.ppuSprRamAddressRegister;
    }

    public void setPpuSprRamAddressRegister(PPUSprRamAddressRegister ppuSprRamAddressRegister) {
        this.ppuSprRamAddressRegister = ppuSprRamAddressRegister;
    }

    public PPUSpriteDMARegister getPpuSpriteDmaRegister() {
        return this.ppuSpriteDmaRegister;
    }

    public void setPpuSpriteDmaRegister(PPUSpriteDMARegister ppuSpriteDmaRegister) {
        this.ppuSpriteDmaRegister = ppuSpriteDmaRegister;
    }

    public PPUMaskRegister getPpuMaskRegister() {
        return this.ppuMaskRegister;
    }

    public void setPpuMaskRegister(PPUMaskRegister ppuMaskRegister) {
        this.ppuMaskRegister = ppuMaskRegister;
    }

    public APUControlRegister getApuControlRegister() {
        return this.apuControlRegister;
    }

    public void setApuControlRegister(APUControlRegister apuControlRegister) {
        this.apuControlRegister = apuControlRegister;
    }

    public APUFrameCounterRegister getApuFrameCounterRegister() {
        return this.apuFrameCounterRegister;
    }

    public void setApuFrameCounterRegister(APUFrameCounterRegister apuFrameCounterRegister) {
        this.apuFrameCounterRegister = apuFrameCounterRegister;
    }

    public APUPulse1ChannelRegister getApuPulse1ChannelRegister() {
        return this.apuPulse1ChannelRegister;
    }

    public void setApuPulse1ChannelRegister(APUPulse1ChannelRegister apuPulse1ChannelRegister) {
        this.apuPulse1ChannelRegister = apuPulse1ChannelRegister;
    }

    public APUPulse1LengthCounterRegister getApuPulse1LengthCounterRegister() {
        return this.apuPulse1LengthCounterRegister;
    }

    public void setApuPulse1LengthCounterRegister(APUPulse1LengthCounterRegister apuPulse1LengthCounterRegister) {
        this.apuPulse1LengthCounterRegister = apuPulse1LengthCounterRegister;
    }

    public APUPulse1SweepRegister getApuPulse1SweepRegister() {
        return this.apuPulse1SweepRegister;
    }

    public void setApuPulse1SweepRegister(APUPulse1SweepRegister apuPulse1SweepRegister) {
        this.apuPulse1SweepRegister = apuPulse1SweepRegister;
    }

    public APUPulse1TimerLowRegister getApuPulse1TimerLowRegister() {
        return this.apuPulse1TimerLowRegister;
    }

    public void setApuPulse1TimerLowRegister(APUPulse1TimerLowRegister apuPulse1TimerLowRegister) {
        this.apuPulse1TimerLowRegister = apuPulse1TimerLowRegister;
    }

    public ControlRegister1 getControlRegister1() {
        return this.controlRegister1;
    }

    public void setControlRegister1(ControlRegister1 controlRegister1) {
        this.controlRegister1 = controlRegister1;
    }

    public ControlRegister2 getControlRegister2() {
        return this.controlRegister2;
    }

    public void setControlRegister2(ControlRegister2 controlRegister2) {
        this.controlRegister2 = controlRegister2;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        logger.info((Object)"setting mapper");
        this.mapper = mapper;
    }
}

