/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.gui.LambNesGui;
import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.interrupts.InterruptRequest;
import com.lambelly.lambnes.platform.interrupts.NesInterrupts;
import com.lambelly.lambnes.platform.ppu.BackgroundTile;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import com.lambelly.lambnes.platform.ppu.PictureProcessingUnit;
import com.lambelly.lambnes.platform.ppu.ScreenBuffer;
import com.lambelly.lambnes.platform.ppu.SpriteAttribute;
import com.lambelly.lambnes.platform.ppu.SpriteTile;
import com.lambelly.lambnes.platform.ppu.registers.PPUControlRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUMaskRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUScrollRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSprRamAddressRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSprRamIORegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUSpriteDMARegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUStatusRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUVramAddressRegister;
import com.lambelly.lambnes.platform.ppu.registers.PPUVramIORegister;
import org.apache.log4j.Logger;

public class NesPpu
implements PictureProcessingUnit {
    private static final int SCANLINE_IDLE = 240;
    private static final int SCANLINE_261 = 261;
    private static final int VBLANK_SCANLINE_START = 241;
    private static final int VBLANK_SCANLINE_END = 260;
    private static final int REFRESH_RATE = 60;
    private static final int NUM_SCANLINES_PER_FRAME = 262;
    private static final int NUM_HORIZONTAL_TILES = 32;
    private static final int NUM_VERTICAL_TILES = 30;
    public static final int SPRITE_COUNT = 64;
    public static final int PPU_CYCLES_PER_LINE = 341;
    public static final int CPU_CYCLES_PER_LINE = 113;
    public static final int CPU_CYCLES_PER_FRAME = 29606;
    public static final int PPU_CYCLES_PER_FRAME = 89342;
    private int scanlineCount = 0;
    private int verticalPerTileCount = 0;
    private int registerAddressFlipFlopLatch = 0;
    private int loopyT = 0;
    private int loopyV = 0;
    private int loopyX = 0;
    private int ppuCyclesUntilEndOfFrame = 89342;
    private int ppuCyclesUntilEndOfLine = 341;
    private long vblankInterval = 0L;
    private ScreenBuffer screenBuffer = new ScreenBuffer();
    private long screenCount = 0L;
    private NesPpuMemory ppuMemory;
    private PPUSprRamIORegister ppuSprRamIORegister;
    private PPUSprRamAddressRegister ppuSprRamAddressRegister;
    private PPUControlRegister ppuControlRegister;
    private PPUStatusRegister ppuStatusRegister;
    private PPUVramAddressRegister ppuVramAddressRegister;
    private PPUVramIORegister ppuVramIORegister;
    private PPUScrollRegister ppuScrollRegister;
    private PPUSpriteDMARegister ppuSpriteDmaRegister;
    private PPUMaskRegister ppuMaskRegister;
    private NesInterrupts interrupts;
    private Logger logger = Logger.getLogger(NesPpu.class);

    @Override
    public void cycle(int cpuCycleCount) {
        this.doRegisterReadsWrites();
        this.subtractFromPpuCyclesUntilEndOfFrame(cpuCycleCount * 3);
        this.subtractFromPpuCyclesUntilEndOfLine(cpuCycleCount * 3);
        if (this.getPpuCyclesUntilEndOfLine() <= 0) {
            if (this.getScanlineCount() >= 241 && this.getScanlineCount() <= 260) {
                this.setLoopyV(this.getLoopyT());
                if (this.getScanlineCount() == 241) {
                    this.getPpuStatusRegister().setVblank(true);
                    this.vblankInterval = Platform.getCycleCount();
                    if (this.getPpuControlRegister().isExecuteNMIOnVBlank()) {
                        this.interrupts.addInterruptRequestToQueue(new InterruptRequest(0));
                    }
                } else if (this.getScanlineCount() == 260) {
                    this.getPpuStatusRegister().setSprite0Occurance(false);
                    this.getPpuStatusRegister().setVblank(false);
                    this.getPpuStatusRegister().setScanlineSpriteCount(false);
                    this.setLoopyV(this.getLoopyT());
                }
                this.incrementScanlineCount();
            } else if (this.getScanlineCount() == 240) {
                this.incrementScanlineCount();
            } else if (this.getScanlineCount() == 261) {
                this.setScanlineCount(0);
            } else {
                this.drawScanline(this.getScanlineCount());
                this.incrementScanlineCount();
                int setLoopyV = this.getLoopyV() & 0xFBE0 | this.getLoopyT() & 0x41F;
                this.setLoopyV(setLoopyV);
            }
            this.addToPpuCyclesUntilEndOfLine(341);
        }
        if (this.getPpuCyclesUntilEndOfFrame() <= 0) {
            this.incrementScreenCount();
            this.getScreenBuffer().pushBufferToScreen();
            this.addToPpuCyclesUntilEndOfFrame(89342);
        }
    }

    private void drawScanline(int scanline) {
        if (this.getPpuMaskRegister().isBackgroundVisibility()) {
            this.drawBackground(scanline);
        }
        if (this.getPpuMaskRegister().isSpriteVisibility()) {
            this.drawSprites(scanline);
            this.getPpuMemory().clearSpriteBuffer();
            this.updateSpriteBuffer(scanline);
        }
        if ((scanline + 1 & 7) == 0) {
            this.incrementVerticalPerTileCount();
            if (this.getVerticalPerTileCount() == 30) {
                this.setVerticalPerTileCount(0);
            }
        }
    }

    private void drawSprites(int verticalPerPixelCount) {
        if (this.getPpuMemory().getSpritesInBufferCount() > 0) {
            int i = 0;
            while (i < this.getPpuMemory().getSpritesInBufferCount()) {
                SpriteTile sprite = this.getPpuMemory().getSpriteFromBuffer(i);
                this.logger.info((Object)("sprite from buffer " + i + ": " + sprite.getSpriteNumber()));
                if (this.drawSpriteTileLine(sprite, verticalPerPixelCount) && !this.getPpuStatusRegister().isSprite0Occurance()) {
                    this.getPpuStatusRegister().setSprite0Occurance(true);
                }
                ++i;
            }
        }
    }

    private boolean drawSpriteTileLine(SpriteTile sprite, int verticalPerPixelCount) {
        boolean sprite0Triggered = false;
        int spriteLine = verticalPerPixelCount - sprite.getAttributes().getyCoordinate();
        this.logger.info((Object)("spriteLine: " + spriteLine + " sprite: " + sprite.getSpriteNumber() + " scanline: " + verticalPerPixelCount + " y coord: " + sprite.getAttributes()));
        spriteLine = this.getPpuControlRegister().getSpriteSize() == 0 ? (spriteLine &= 7) : (spriteLine &= 0xF);
        int spriteXPosition = sprite.getAttributes().getxCoordinate();
        int sprite0Number = this.getPpuMemory().getSprRam(0).getTileIndex();
        PaletteColor backgroundTransparentColor = this.getPpuMemory().getImagePaletteColor(0);
        PaletteColor[] spriteRow = sprite.getTileColorRow(spriteLine);
        int pixelIndex = 0;
        while (pixelIndex < spriteRow.length) {
            PaletteColor pixelToBeDrawn = spriteRow[pixelIndex];
            if (pixelToBeDrawn.getPaletteIndex() != 0 && pixelToBeDrawn.getPaletteIndex() != 4 && pixelToBeDrawn.getPaletteIndex() != 8 && pixelToBeDrawn.getPaletteIndex() != 12) {
                if (LambNesGui.getScreen().getImage().getRGB(spriteXPosition + pixelIndex & 0xFF, verticalPerPixelCount) != backgroundTransparentColor.getMasterPaletteColor().getColorInt() && sprite.getSpriteNumber() == sprite0Number && !this.getPpuStatusRegister().isSprite0Occurance()) {
                    sprite0Triggered = true;
                }
                if (spriteXPosition >= 8 || this.getPpuMaskRegister().isSpriteVisibility()) {
                    this.logger.info((Object)("drawing pixel " + pixelIndex + " of line " + spriteLine + " of sprite number: " + sprite.getSpriteNumber() + " index: " + sprite.getAttributes().getTileIndex() + " at y: " + verticalPerPixelCount + " x: " + (spriteXPosition & 0xFF) + " sprite0: " + this.getPpuStatusRegister().isSprite0Occurance() + " color: " + pixelToBeDrawn.getMasterPaletteIndex()));
                    this.getScreenBuffer().setScreenBufferPixel(spriteXPosition & 0xFF, verticalPerPixelCount, pixelToBeDrawn);
                }
            }
            ++spriteXPosition;
            ++pixelIndex;
        }
        return sprite0Triggered;
    }

    private void updateSpriteBuffer(int verticalPerPixelCount) {
        this.getPpuStatusRegister().setScanlineSpriteCount(false);
        int spriteCount = 0;
        int spriteAttributeIndexNumber = 0;
        while (spriteAttributeIndexNumber < 64) {
            SpriteAttribute spriteAttribute = this.getPpuMemory().getSprRam(spriteAttributeIndexNumber);
            this.logger.info((Object)("scanline: " + verticalPerPixelCount + " spriteAttributeIndexNumber: " + spriteAttributeIndexNumber + " tileIndex: " + spriteAttribute.getTileIndex() + " spriteYcoordinate: " + spriteAttribute.getyCoordinate()));
            int diff = verticalPerPixelCount + 1 - spriteAttribute.getyCoordinate();
            if (diff >= 0 && diff <= 7 || this.getPpuControlRegister().getSpriteSize() == 1 && diff >= 0 && diff <= 15) {
                SpriteTile sprite = new SpriteTile(spriteAttribute.getTileIndex(), spriteAttribute);
                this.logger.info((Object)("adding sprite to buffer: scanline: " + verticalPerPixelCount + " tileIndex: " + spriteAttribute.getTileIndex() + " spriteYcoordinate: " + spriteAttribute.getyCoordinate() + " diff: " + diff + " spritecount: " + spriteCount + " spriteNumber: " + sprite.getSpriteNumber()));
                this.logger.info((Object)("sprite: " + sprite));
                this.getPpuMemory().setSpriteToBuffer(spriteCount, sprite);
                if (++spriteCount == 9) {
                    spriteCount = 8;
                    this.getPpuStatusRegister().setScanlineSpriteCount(true);
                    break;
                }
            }
            ++spriteAttributeIndexNumber;
        }
    }

    private void drawBackground(int scanline) {
        int horizontalPerTileCount = 0;
        while (horizontalPerTileCount < 32) {
            int hCoarseScrollOffset = this.getLoopyV() & 0x1F;
            int offsetHorizontalPerTileCount = horizontalPerTileCount + hCoarseScrollOffset;
            int hFineScrollOffset = this.getLoopyX() & 7;
            int vCoarseScrollOffset = (this.getLoopyV() & 0x3E0) >> 5;
            int offsetVerticalPerTileCount = this.getVerticalPerTileCount() + vCoarseScrollOffset;
            int vFineScrollOffset = (this.getLoopyV() & 0x7000) >> 12;
            int horizontalNameCount = this.getPpuControlRegister().getNameTableAddress();
            int verticalNameCount = this.getPpuControlRegister().getNameTableAddress();
            int tileYindex = scanline & 7;
            if ((tileYindex += vFineScrollOffset) > 7) {
                tileYindex &= 7;
                ++offsetVerticalPerTileCount;
            }
            if (offsetHorizontalPerTileCount * 8 + hFineScrollOffset > 256) {
                horizontalNameCount = 1 ^ horizontalNameCount;
                offsetHorizontalPerTileCount &= 0x1F;
            }
            if (offsetVerticalPerTileCount * 8 + vFineScrollOffset >= 240) {
                verticalNameCount = 1 ^ verticalNameCount;
                offsetVerticalPerTileCount %= 30;
            }
            int nameTableAddress = 8192 + offsetHorizontalPerTileCount | offsetVerticalPerTileCount << 5 | horizontalNameCount << 10 | verticalNameCount << 11;
            this.drawBackgroundTile(nameTableAddress, horizontalPerTileCount, hFineScrollOffset, vFineScrollOffset, tileYindex, scanline);
            ++horizontalPerTileCount;
        }
    }

    private void drawBackgroundTile(int nameTableAddress, int horizontalPerTileCount, int hFineScrollOffset, int vFineScrollOffset, int tileYindex, int scanline) {
        if (horizontalPerTileCount >= 1 || !this.getPpuMaskRegister().isBackGroundClipping()) {
            PaletteColor[] tileRow = new PaletteColor[8];
            BackgroundTile bg = this.getPpuMemory().getNameTableFromHexAddress(nameTableAddress).getTileFromHexAddress(nameTableAddress);
            System.arraycopy(bg.getTileColorRow(tileYindex), 0, tileRow, 0, tileRow.length);
            this.getScreenBuffer().setScreenBufferTileRow(horizontalPerTileCount * 8, scanline, hFineScrollOffset, vFineScrollOffset, tileRow);
        }
    }

    private void doRegisterReadsWrites() {
        this.getPpuControlRegister().cycle();
        this.getPpuMaskRegister().cycle();
        this.getPpuStatusRegister().cycle();
        this.getPpuSpriteDmaRegister().cycle();
        this.getPpuSprRamAddressRegister().cycle();
        this.getPpuSprRamIORegister().cycle();
        this.getPpuScrollRegister().cycle();
        this.getPpuVramAddressRegister().cycle();
        this.getPpuVramIORegister().cycle();
    }

    @Override
    public int getScanlineCount() {
        return this.scanlineCount;
    }

    public void incrementScanlineCount() {
        ++this.scanlineCount;
    }

    public void setScanlineCount(int scanlineCount) {
        this.scanlineCount = scanlineCount;
    }

    public int getVerticalPerTileCount() {
        return this.verticalPerTileCount;
    }

    public void setVerticalPerTileCount(int verticalTileCount) {
        this.verticalPerTileCount = verticalTileCount;
    }

    public void incrementVerticalPerTileCount() {
        ++this.verticalPerTileCount;
    }

    @Override
    public int getRegisterAddressFlipFlopLatch() {
        int latchValue = this.registerAddressFlipFlopLatch;
        this.flipRegisterAddressFlipFlopLatch();
        return latchValue;
    }

    public void flipRegisterAddressFlipFlopLatch() {
        this.registerAddressFlipFlopLatch = 1 ^ this.registerAddressFlipFlopLatch;
    }

    @Override
    public void resetRegisterAddressFlipFlopLatch() {
        this.registerAddressFlipFlopLatch = 0;
    }

    public void setRegisterAddressFlipFlopLatch(int registerAddressFlipFlopLatch) {
        this.registerAddressFlipFlopLatch = registerAddressFlipFlopLatch;
    }

    public ScreenBuffer getScreenBuffer() {
        return this.screenBuffer;
    }

    public void setScreenBuffer(ScreenBuffer screenBuffer) {
        this.screenBuffer = screenBuffer;
    }

    @Override
    public int getLoopyT() {
        return this.loopyT;
    }

    @Override
    public void setLoopyT(int loopyT) {
        this.loopyT = loopyT;
    }

    public int getLoopyV() {
        return this.loopyV;
    }

    @Override
    public void setLoopyV(int loopyV) {
        this.loopyV = loopyV;
    }

    public int getLoopyX() {
        return this.loopyX;
    }

    @Override
    public void setLoopyX(int loopyX) {
        this.loopyX = loopyX;
    }

    public int getPpuCyclesUntilEndOfFrame() {
        return this.ppuCyclesUntilEndOfFrame;
    }

    public void setPpuCyclesUntilEndOfFrame(int ppuCyclesUntilEndOfFrame) {
        this.ppuCyclesUntilEndOfFrame = ppuCyclesUntilEndOfFrame;
    }

    public void addToPpuCyclesUntilEndOfFrame(int cycles) {
        this.ppuCyclesUntilEndOfFrame += cycles;
    }

    public void subtractFromPpuCyclesUntilEndOfFrame(int cycles) {
        this.ppuCyclesUntilEndOfFrame -= cycles;
    }

    public int getPpuCyclesUntilEndOfLine() {
        return this.ppuCyclesUntilEndOfLine;
    }

    public void setPpuCyclesUntilEndOfLine(int ppuCyclesUntilEndOfLine) {
        this.ppuCyclesUntilEndOfLine = ppuCyclesUntilEndOfLine;
    }

    public void addToPpuCyclesUntilEndOfLine(int cycles) {
        this.ppuCyclesUntilEndOfLine += cycles;
    }

    public void subtractFromPpuCyclesUntilEndOfLine(int cycles) {
        this.ppuCyclesUntilEndOfLine -= cycles;
    }

    @Override
    public long getScreenCount() {
        return this.screenCount;
    }

    public void setScreenCount(long screenCount) {
        this.screenCount = screenCount;
    }

    public void incrementScreenCount() {
        ++this.screenCount;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public PPUSprRamIORegister getPpuSprRamIORegister() {
        return this.ppuSprRamIORegister;
    }

    public void setPpuSprRamIORegister(PPUSprRamIORegister ppuSprRamIORegister) {
        this.ppuSprRamIORegister = ppuSprRamIORegister;
    }

    public PPUControlRegister getPpuControlRegister() {
        return this.ppuControlRegister;
    }

    public void setPpuControlRegister(PPUControlRegister ppuControlRegister) {
        this.ppuControlRegister = ppuControlRegister;
    }

    public PPUStatusRegister getPpuStatusRegister() {
        return this.ppuStatusRegister;
    }

    public void setPpuStatusRegister(PPUStatusRegister ppuStatusRegister) {
        this.ppuStatusRegister = ppuStatusRegister;
    }

    public PPUVramAddressRegister getPpuVramAddressRegister() {
        return this.ppuVramAddressRegister;
    }

    public void setPpuVramAddressRegister(PPUVramAddressRegister ppuVramAddressRegister) {
        this.ppuVramAddressRegister = ppuVramAddressRegister;
    }

    public PPUVramIORegister getPpuVramIORegister() {
        return this.ppuVramIORegister;
    }

    public void setPpuVramIORegister(PPUVramIORegister ppuVramIORegister) {
        this.ppuVramIORegister = ppuVramIORegister;
    }

    public PPUScrollRegister getPpuScrollRegister() {
        return this.ppuScrollRegister;
    }

    public void setPpuScrollRegister(PPUScrollRegister ppuScrollRegister) {
        this.ppuScrollRegister = ppuScrollRegister;
    }

    public PPUSprRamAddressRegister getPpuSprRamAddressRegister() {
        return this.ppuSprRamAddressRegister;
    }

    public void setPpuSprRamAddressRegister(PPUSprRamAddressRegister ppuSprRamAddressRegister) {
        this.ppuSprRamAddressRegister = ppuSprRamAddressRegister;
    }

    public PPUSpriteDMARegister getPpuSpriteDmaRegister() {
        return this.ppuSpriteDmaRegister;
    }

    public void setPpuSpriteDmaRegister(PPUSpriteDMARegister ppuSpriteDmaRegister) {
        this.ppuSpriteDmaRegister = ppuSpriteDmaRegister;
    }

    public PPUMaskRegister getPpuMaskRegister() {
        return this.ppuMaskRegister;
    }

    public void setPpuMaskRegister(PPUMaskRegister ppuMaskRegister) {
        this.ppuMaskRegister = ppuMaskRegister;
    }

    public NesInterrupts getInterrupts() {
        return this.interrupts;
    }

    public void setInterrupts(NesInterrupts interrupts) {
        this.interrupts = interrupts;
    }
}

