/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.NesTileAttribute;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import com.lambelly.lambnes.util.NumberConversionUtils;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public abstract class NesTile {
    protected int tileNumber = 0;
    protected int[] patternA = null;
    protected int[] patternB = null;
    private NesPpuMemory ppuMemory = LambNes.getPlatform().getPpuMemory();
    protected Logger logger = Logger.getLogger(NesTile.class);

    public NesTile() {
    }

    public NesTile(int tileNumber) {
        this.setTileNumber(tileNumber);
        this.instantiateTile();
    }

    public NesTile(int tileNumber, int colorHighBit) {
        this.setTileNumber(tileNumber);
        this.setAttributes(colorHighBit);
        this.instantiateTile();
    }

    public NesTile(NesTile tile) {
        this.setTileNumber(tile.getTileNumber());
        this.setAttributes(tile.getAttributes().getColorHighBit());
        this.setPatternA(tile.getPatternA());
        this.setPatternB(tile.getPatternB());
    }

    protected abstract void instantiateTile();

    public abstract void refreshAttributes();

    public void refreshTile() {
        this.refreshAttributes();
        this.instantiateTile();
    }

    public int[] getTileByteArray(int tileNumber) {
        int address = this.getNameTableSelectBit() * 4096 | tileNumber * 16;
        int spriteLength = 16;
        int[] tile = new int[spriteLength];
        int x = 0;
        while (x < spriteLength) {
            int value;
            tile[x] = value = LambNes.getPlatform().getPpuMemory().getMemoryFromHexAddress(address + x);
            ++x;
        }
        return tile;
    }

    public PaletteColor getTileColorRowPixel(int row, int column) {
        return this.getTileColorRow(row)[column];
    }

    public PaletteColor[] getTileColorRow(int row) {
        PaletteColor[] colorBit = new PaletteColor[8];
        int i = 0;
        while (i < 8) {
            PaletteColor pixel;
            colorBit[i ^ 7] = pixel = this.getPpuMemory().getImagePaletteColor(this.getPixelColorPaletteIndex(i, row));
            ++i;
        }
        return colorBit;
    }

    public abstract int getPixelColorPaletteIndex(int var1, int var2);

    public BufferedImage getBufferedImage() {
        int width = 8;
        int height = 8;
        BufferedImage bImage = new BufferedImage(width, height, 1);
        int row = 0;
        while (row < 8) {
            PaletteColor[] p = this.getTileColorRow(row);
            int col = 0;
            while (col < 8) {
                bImage.setRGB(col, row, p[col].getMasterPaletteColor().getColorInt());
                ++col;
            }
            ++row;
        }
        return bImage;
    }

    public abstract int getNameTableSelectBit();

    public String toString() {
        String colorMapString = "";
        int row = 0;
        while (row < 8) {
            colorMapString = String.valueOf(colorMapString) + "\n";
            int col = 0;
            while (col < 8) {
                colorMapString = String.valueOf(colorMapString) + this.getPixelColorPaletteIndex(col, row);
                ++col;
            }
            ++row;
        }
        return "background tile number: " + this.getTileNumber() + "\n" + "patternA: \n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[0], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[1], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[2], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[3], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[4], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[5], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[6], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[7], 8) + "\n" + "patternB: \n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[0], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[1], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[2], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[3], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[4], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[5], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[6], 8) + "\n" + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[7], 8) + "\n" + "\t\tbackground color palette index map: " + colorMapString;
    }

    public int getTileNumber() {
        return this.tileNumber;
    }

    public void setTileNumber(int tileNumber) {
        this.tileNumber = tileNumber;
    }

    public int[] getPatternA() {
        return this.patternA;
    }

    public void setPatternA(int[] patternA) {
        this.patternA = patternA;
    }

    public int[] getPatternB() {
        return this.patternB;
    }

    public void setPatternB(int[] patternB) {
        this.patternB = patternB;
    }

    public abstract NesTileAttribute getAttributes();

    public abstract void setAttributes(int var1);

    public abstract void setAttributes(NesTileAttribute var1);

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

