/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.platform.ppu.BackgroundTile;
import com.lambelly.lambnes.platform.ppu.NesTileCache;
import org.apache.log4j.Logger;

public class PPUNameTable {
    private int[] nameTable = new int[960];
    private int[] attributeTable = new int[64];
    private static final int BASE_ADDRESS_MASK = 1023;
    private NesTileCache tileCache = new NesTileCache();
    private Logger logger = Logger.getLogger(PPUNameTable.class);

    public void setMemoryFromHexAddress(int address, int value) {
        int index = address & 0x3FF;
        if (index >= 0 && index < 960) {
            this.getNameTable()[index] = value;
        } else if (index >= 960 && index < 1024) {
            this.getAttributeTable()[index - 960] = value;
        } else {
            throw new IllegalStateException("tried to set memory address 0x" + Integer.toHexString(address) + " which is not mapped to any data structure");
        }
    }

    public BackgroundTile getTileFromHexAddress(int address) throws IllegalStateException {
        int index = address & 0x3FF;
        if (index >= 0 && index <= 959) {
            int colorMSB = 0;
            int nameTableRow = index >> 5;
            int nameTableCol = index & 0x1F;
            colorMSB = this.getColorMSB(nameTableRow, nameTableCol);
            BackgroundTile bTile = this.getTileCache().getBackgroundTile(this.getMemoryFromHexAddress(address), colorMSB);
            return bTile;
        }
        throw new IllegalStateException("tried to access memory address 0x" + Integer.toHexString(address) + " which is not mapped to any data structure");
    }

    public int getMemoryFromHexAddress(int address) throws IllegalStateException {
        int index = address & 0x3FF;
        int value = 0;
        if (index >= 0 && index <= 959) {
            value = this.getNameTable()[index];
        } else if (index >= 960 && index <= 1023) {
            value = this.getAttributeTable()[index - 960];
        } else {
            throw new IllegalStateException("tried to access memory address 0x" + Integer.toHexString(address) + " which is not mapped to any data structure");
        }
        return value;
    }

    private int getColorMSB(int nameTableRow, int nameTableCol) {
        int attributeTableCol = nameTableCol / 4 & 7;
        int attributeTableRow = nameTableRow / 4 & 7;
        int attributeIndex = attributeTableRow << 3 | attributeTableCol;
        int attributeValue = this.getAttributeTable()[attributeIndex];
        int bit1 = nameTableCol & 2;
        int bit2 = nameTableRow & 2;
        int shift = bit1 | bit2 << 1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("looking up background attribute row: " + nameTableRow + " col: " + nameTableCol + " attributeIndex: " + attributeIndex + " attributeValue: " + attributeValue + " shift " + shift));
        }
        return attributeValue >> shift & 3;
    }

    public int[] getNameTable() {
        return this.nameTable;
    }

    public void setNameTable(int[] nameTable) {
        this.nameTable = nameTable;
    }

    public int[] getAttributeTable() {
        return this.attributeTable;
    }

    public void setAttributeTable(int[] attributeTable) {
        this.attributeTable = attributeTable;
    }

    public NesTileCache getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(NesTileCache tileCache) {
        this.tileCache = tileCache;
    }
}

