/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.platform.ppu.NesTile;
import com.lambelly.lambnes.platform.ppu.NesTileAttribute;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import com.lambelly.lambnes.platform.ppu.SpriteAttribute;
import com.lambelly.lambnes.util.BitUtils;
import com.lambelly.lambnes.util.NumberConversionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class SpriteTile
extends NesTile {
    private int spriteNumber = 0;
    private int[] patternA = null;
    private int[] patternB = null;
    private SpriteAttribute spriteAttribute = new SpriteAttribute();
    private Logger logger = Logger.getLogger(SpriteTile.class);

    public SpriteTile(int spriteNumber) {
        this.setSpriteNumber(spriteNumber);
        this.instantiateTile();
    }

    public SpriteTile(int spriteNumber, SpriteAttribute attribute) {
        this.setSpriteNumber(spriteNumber);
        this.setAttributes(attribute);
        this.instantiateTile();
    }

    public SpriteTile(SpriteTile tile) {
        this.setSpriteNumber(tile.getSpriteNumber());
        this.setPatternA(tile.getPatternA());
        this.setPatternB(tile.getPatternB());
    }

    public int[] getTileByteArray() {
        int spriteLength;
        int address;
        if (LambNes.getPlatform().getPpu().getPpuControlRegister().getSpriteSize() == 0) {
            int tileNumber = this.getAttributes().getTileIndex();
            this.logger.info((Object)"not using 8x16 logics");
            address = this.getNameTableSelectBit() * 4096 | tileNumber * 16;
            spriteLength = 16;
        } else {
            this.logger.info((Object)"using 8x16 logics");
            this.logger.info((Object)("8x16: tile: " + this.getAttributes().getTileIndex()));
            address = ((this.getAttributes().getTileIndex() & 1) == 1 ? 4096 : 0) + (this.getAttributes().getTileIndex() & 0xFE) * 16;
            this.logger.info((Object)("tileNumber: " + this.getAttributes().getTileIndex() + " address: " + address));
            spriteLength = 32;
        }
        int[] tile = new int[spriteLength];
        int x = 0;
        while (x < spriteLength) {
            int value;
            tile[x] = value = LambNes.getPlatform().getPpuMemory().getMemoryFromHexAddress(address + x);
            ++x;
        }
        return tile;
    }

    @Override
    protected void instantiateTile() {
        int[] sprite = this.getTileByteArray();
        if (LambNes.getPlatform().getPpu().getPpuControlRegister().getSpriteSize() == 0) {
            this.setPatternA(ArrayUtils.subarray((int[])sprite, (int)0, (int)8));
            this.setPatternB(ArrayUtils.subarray((int[])sprite, (int)8, (int)16));
        } else {
            this.setPatternA(new int[16]);
            this.setPatternB(new int[16]);
            this.logger.info((Object)("sprite size: " + sprite.length));
            System.arraycopy(sprite, 0, this.getPatternA(), 0, 8);
            System.arraycopy(sprite, 8, this.getPatternB(), 0, 8);
            System.arraycopy(sprite, 16, this.getPatternA(), 8, 8);
            System.arraycopy(sprite, 24, this.getPatternB(), 8, 8);
        }
    }

    @Override
    public PaletteColor[] getTileColorRow(int row) {
        PaletteColor[] colorBit = new PaletteColor[8];
        int i = 0;
        while (i < 8) {
            PaletteColor pixel;
            colorBit[i ^ 7] = pixel = super.getPpuMemory().getSpritePaletteColor(this.getPixelColorPaletteIndex(i, row));
            this.logger.info((Object)("setting colorBit " + (i ^ 7) + " to mpc: " + pixel.getMasterPaletteIndex() + " pi: " + pixel.getPaletteIndex() + " for row: " + row + " of sprite: " + this.getSpriteNumber()));
            ++i;
        }
        return colorBit;
    }

    @Override
    public int getPixelColorPaletteIndex(int column, int row) {
        if (this.getPatternA() == null) {
            this.refreshTile();
        }
        if (this.getAttributes().isHorizontalFlip()) {
            column ^= 7;
        }
        if (this.getAttributes().isVerticalFlip()) {
            row ^= 7;
        }
        int color = 0;
        color = this.getAttributes().getColorHighBit() << 2 | (BitUtils.isBitSet(this.getPatternB()[row], column) ? 1 : 0) << 1 | (BitUtils.isBitSet(this.getPatternA()[row], column) ? 1 : 0);
        this.logger.debug((Object)("pattern a pixel: " + (BitUtils.isBitSet(this.getPatternA()[row], column) ? 1 : 0)));
        this.logger.debug((Object)("pattern b pixel: " + ((BitUtils.isBitSet(this.getPatternB()[row], column) ? 1 : 0) << 1)));
        this.logger.debug((Object)("color bitstring generated for sprite " + this.getSpriteNumber() + ": c: " + column + ", r: " + row + ": " + Integer.toBinaryString(color)));
        return color;
    }

    @Override
    public void refreshAttributes() {
        this.setAttributes(LambNes.getPlatform().getPpuMemory().getSprRamForSpriteNumber(this.getSpriteNumber()));
    }

    @Override
    public int getNameTableSelectBit() {
        return LambNes.getPlatform().getPpu().getPpuControlRegister().getSpritePatternTableAddress();
    }

    @Override
    public String toString() {
        int rows = this.patternA.length;
        String colorMapString = "";
        String patternA = "patternA: \n";
        String patternB = "patternB: \n";
        int row = 0;
        while (row < rows) {
            patternA = String.valueOf(patternA) + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternA[row], 8) + "\n";
            patternB = String.valueOf(patternB) + "\t" + NumberConversionUtils.generateBinaryStringWithleadingZeros(this.patternB[row], 8) + "\n";
            colorMapString = String.valueOf(colorMapString) + "\n";
            int col = 0;
            while (col < 8) {
                colorMapString = String.valueOf(colorMapString) + this.getPixelColorPaletteIndex(col, row);
                ++col;
            }
            ++row;
        }
        return String.valueOf(patternA) + patternB + "\t\tcolor high bit: " + this.getAttributes().getColorHighBit() + "\n" + "\t\tcolor map: " + colorMapString;
    }

    public int getSpriteNumber() {
        return this.spriteNumber;
    }

    public void setSpriteNumber(int spriteNumber) {
        this.spriteNumber = spriteNumber;
    }

    @Override
    public int[] getPatternA() {
        return this.patternA;
    }

    @Override
    public void setPatternA(int[] patternA) {
        this.patternA = patternA;
    }

    @Override
    public int[] getPatternB() {
        return this.patternB;
    }

    @Override
    public void setPatternB(int[] patternB) {
        this.patternB = patternB;
    }

    @Override
    public SpriteAttribute getAttributes() {
        return this.spriteAttribute;
    }

    @Override
    public void setAttributes(int spriteNumber) {
        this.spriteAttribute = LambNes.getPlatform().getPpuMemory().getSprRamForSpriteNumber(spriteNumber);
    }

    @Override
    public void setAttributes(NesTileAttribute spriteAttributes) {
        this.spriteAttribute = (SpriteAttribute)spriteAttributes;
    }
}

