/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.util.BitUtils;

public class PPUMaskRegister {
    public static final int REGISTER_ADDRESS = 8193;
    public static final int FULL_BACKGROUND_COLOR_NONE = 0;
    public static final int FULL_BACKGROUND_COLOR_GREEN = 1;
    public static final int FULL_BACKGROUND_COLOR_BLUE = 2;
    public static final int FULL_BACKGROUND_COLOR_RED = 3;
    public static final int COLOR_INTENSITY_NONE = 0;
    public static final int COLOR_INTENSITY_GREEN = 1;
    public static final int COLOR_INTENSITY_BLUE = 2;
    public static final int COLOR_INTENSITY_RED = 3;
    public static final int DISPLAY_TYPE_COLOR = 0;
    public static final int DISPLAY_TYPE_MONOCHROME = 1;
    private static final int CYCLES_PER_EXECUTION = 0;
    private Integer rawControlByte = null;
    private Integer controlByte = null;
    private int fullBackgroundColor = 0;
    private int colorIntensity = 0;
    private boolean spriteVisibility = false;
    private boolean backgroundVisibility = false;
    private boolean spriteClipping = false;
    private boolean backGroundClipping = false;
    private int displayType = 0;

    private PPUMaskRegister() {
    }

    public int cycle() {
        if (this.getRawControlByte() != null && this.getControlByte() != this.getRawControlByte()) {
            this.setControlByte(this.getRawControlByte());
            this.setSpriteVisibility(BitUtils.isBitSet(this.getRawControlByte(), 4));
            this.setBackgroundVisibility(BitUtils.isBitSet(this.getRawControlByte(), 3));
            this.setSpriteClipping(!BitUtils.isBitSet(this.getRawControlByte(), 2));
            this.setBackGroundClipping(!BitUtils.isBitSet(this.getRawControlByte(), 1));
            this.setDisplayType(BitUtils.isBitSet(this.getRawControlByte(), 0) ? 1 : 0);
            if (this.getDisplayType() == 1) {
                if (BitUtils.isBitSet(this.getRawControlByte(), 7)) {
                    this.setFullBackgroundColor(3);
                } else if (BitUtils.isBitSet(this.getRawControlByte(), 6)) {
                    this.setFullBackgroundColor(2);
                } else if (BitUtils.isBitSet(this.getRawControlByte(), 5)) {
                    this.setFullBackgroundColor(1);
                } else {
                    this.setFullBackgroundColor(0);
                }
            } else if (BitUtils.isBitSet(this.getRawControlByte(), 7)) {
                this.setColorIntensity(3);
            } else if (BitUtils.isBitSet(this.getRawControlByte(), 6)) {
                this.setColorIntensity(2);
            } else if (BitUtils.isBitSet(this.getRawControlByte(), 5)) {
                this.setColorIntensity(1);
            } else {
                this.setColorIntensity(0);
            }
        }
        return 0;
    }

    public String toString() {
        if (this.getRawControlByte() != null) {
            return "0x8193: " + Integer.toBinaryString(this.getRawControlByte());
        }
        return "0x8193: 0";
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    public int getFullBackgroundColor() {
        return this.fullBackgroundColor;
    }

    private void setFullBackgroundColor(int fullBackgroundColor) {
        this.fullBackgroundColor = fullBackgroundColor;
    }

    public int getColorIntensity() {
        return this.colorIntensity;
    }

    private void setColorIntensity(int colorIntensity) {
        this.colorIntensity = colorIntensity;
    }

    public boolean isSpriteVisibility() {
        return this.spriteVisibility;
    }

    private void setSpriteVisibility(boolean spriteVisibility) {
        this.spriteVisibility = spriteVisibility;
    }

    public boolean isBackgroundVisibility() {
        return this.backgroundVisibility;
    }

    private void setBackgroundVisibility(boolean backgroundVisibility) {
        this.backgroundVisibility = backgroundVisibility;
    }

    public boolean isSpriteClipping() {
        return this.spriteClipping;
    }

    private void setSpriteClipping(boolean spriteClipping) {
        this.spriteClipping = spriteClipping;
    }

    public boolean isBackGroundClipping() {
        return this.backGroundClipping;
    }

    private void setBackGroundClipping(boolean backGroundClipping) {
        this.backGroundClipping = backGroundClipping;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    private void setDisplayType(int displayType) {
        this.displayType = displayType;
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(int rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public Integer getControlByte() {
        return this.controlByte;
    }

    public void setControlByte(Integer controlByte) {
        this.controlByte = controlByte;
    }
}

