/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.platform.ppu.NesPpu;
import com.lambelly.lambnes.platform.ppu.registers.PPUVramIORegister;
import com.lambelly.lambnes.util.BitUtils;
import org.apache.log4j.Logger;

public class PPUVramAddressRegister {
    public static final int REGISTER_ADDRESS = 8198;
    private static final int CYCLES_PER_EXECUTION = 0;
    private Integer addressLowByte = null;
    private Integer addressHighByte = null;
    private Integer rawControlByte = null;
    private Logger logger = Logger.getLogger(PPUVramAddressRegister.class);
    private NesPpu ppu;
    private PPUVramIORegister ppuVramIORegister;

    private PPUVramAddressRegister() {
    }

    public int cycle() {
        if (this.getRawControlByte() != null) {
            int flipflop = this.getPpu().getRegisterAddressFlipFlopLatch();
            int loopyT = this.getPpu().getLoopyT();
            int setLoopyT = 0;
            if (flipflop == 1) {
                this.setAddressLowByte(this.getRawControlByte());
                this.getPpuVramIORegister().setIoAddress(BitUtils.unsplitAddress(this.getAddressHighByte(), this.getAddressLowByte()));
                setLoopyT = loopyT & 0xFF00 | this.getRawControlByte();
                this.getPpu().setLoopyT(setLoopyT);
                this.getPpu().setLoopyV(this.getPpu().getLoopyT());
                this.logger.debug((Object)("io address: " + BitUtils.unsplitAddress(this.getAddressHighByte(), this.getAddressLowByte())));
            } else {
                setLoopyT = loopyT & 0xBFFF;
                setLoopyT = loopyT & 0xC0FF | this.getRawControlByte() & 0x3F;
                this.getPpu().setLoopyT(setLoopyT);
            }
            if (flipflop == 1) {
                this.clear();
            } else {
                this.setAddressHighByte(this.getRawControlByte());
                this.setRawControlByte(null);
            }
        }
        return 0;
    }

    private void clear() {
        this.setAddressLowByte(null);
        this.setAddressHighByte(null);
        this.setRawControlByte(null);
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getAddressLowByte() {
        return this.addressLowByte;
    }

    private void setAddressLowByte(Integer addressLowByte) {
        this.addressLowByte = addressLowByte;
    }

    private Integer getAddressHighByte() {
        return this.addressHighByte;
    }

    private void setAddressHighByte(Integer addressHighByte) {
        this.addressHighByte = addressHighByte;
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public NesPpu getPpu() {
        return this.ppu;
    }

    public void setPpu(NesPpu ppu) {
        this.ppu = ppu;
    }

    public PPUVramIORegister getPpuVramIORegister() {
        return this.ppuVramIORegister;
    }

    public void setPpuVramIORegister(PPUVramIORegister ppuVramIORegister) {
        this.ppuVramIORegister = ppuVramIORegister;
    }
}

