/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.ppu.registers;

import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.registers.PPUControlRegister;
import org.apache.log4j.Logger;

public class PPUVramIORegister {
    public static final int REGISTER_ADDRESS = 8199;
    private static final int CYCLES_PER_EXECUTION = 0;
    private Integer ioAddress = null;
    private Integer rawControlByte = null;
    private int vramBuffer = 0;
    private NesPpuMemory ppuMemory;
    private PPUControlRegister ppuControlRegister;
    private Logger logger = Logger.getLogger(PPUVramIORegister.class);

    private PPUVramIORegister() {
    }

    public int cycle() {
        if (this.getIoAddress() != null && this.getRawControlByte() != null) {
            this.getPpuMemory().setMemoryFromHexAddress(this.getIoAddress(), this.getRawControlByte());
            this.incrementIoAddress();
        }
        this.clear();
        return 0;
    }

    private void clear() {
        this.setRawControlByte(null);
    }

    public int getRegisterValue() {
        int value = 0;
        int bufferedValue = this.getVramBuffer();
        if (this.getIoAddress() >= 16128 && this.getIoAddress() <= 16383) {
            this.setVramBuffer(this.getPpuMemory().getNameTable3().getMemoryFromHexAddress(this.getIoAddress()));
        } else {
            this.setVramBuffer(this.getPpuMemory().getMemoryFromHexAddress(this.getIoAddress()));
        }
        value = this.getIoAddress() >= 16128 && this.getIoAddress() <= 16383 ? this.getPpuMemory().getMemoryFromHexAddress(this.getIoAddress()) : bufferedValue;
        this.incrementIoAddress();
        return value;
    }

    public void setRegisterValue(int value) {
        this.setRawControlByte(value);
    }

    private Integer getIoAddress() {
        return this.ioAddress;
    }

    protected void setIoAddress(Integer ioAddress) {
        this.ioAddress = ioAddress;
    }

    private void incrementIoAddress() {
        this.ioAddress = this.getPpuControlRegister().getPpuAddressIncrement() == 0 ? Integer.valueOf(this.ioAddress + 1) : Integer.valueOf(this.ioAddress + 32);
    }

    private Integer getRawControlByte() {
        return this.rawControlByte;
    }

    private void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }

    public int getVramBuffer() {
        return this.vramBuffer;
    }

    public void setVramBuffer(int buffer) {
        this.vramBuffer = buffer;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }

    public PPUControlRegister getPpuControlRegister() {
        return this.ppuControlRegister;
    }

    public void setPpuControlRegister(PPUControlRegister ppuControlRegister) {
        this.ppuControlRegister = ppuControlRegister;
    }
}

