/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.cartridge.RomLoader;
import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.ppu.BackgroundTile;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.test.TileTestImageViewer;
import com.lambelly.lambnes.util.ArrayUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class BackgroundTileTest {
    @Autowired
    private Platform platform;
    @Autowired
    private Ines cartridge;
    @Autowired
    private NesPpuMemory ppuMemory;
    private Logger logger = Logger.getLogger(BackgroundTileTest.class);

    @Test
    public void testColorIndex() {
        BackgroundTile bg = new BackgroundTile();
        int[] nArray = new int[8];
        nArray[4] = 128;
        nArray[5] = 128;
        nArray[6] = 128;
        bg.setPatternA(nArray);
        int[] nArray2 = new int[8];
        nArray2[2] = 128;
        nArray2[3] = 128;
        nArray2[4] = 64;
        nArray2[5] = 96;
        nArray2[6] = 32;
        bg.setPatternB(nArray2);
        bg.setAttributes(4);
        Assert.assertEquals((long)18L, (long)bg.getPixelColorPaletteIndex(7, 2));
    }

    @Test
    public void testColorIndex2() throws Exception {
        RomLoader rl = new RomLoader("./roms/BalloonFight.zip");
        this.getCartridge().init(rl.getRomData());
        ArrayUtils.head(this.getCartridge().getPatternTiles(), 16);
        this.getPpuMemory().setPatternTiles(this.getCartridge().getPatternTiles());
        BackgroundTile bg = new BackgroundTile(36, 4);
        Assert.assertEquals((long)18L, (long)bg.getPixelColorPaletteIndex(7, 2));
    }

    @Test
    public void testColorIndex3() throws Exception {
        RomLoader rl = new RomLoader("./roms/BalloonFight.zip");
        this.getCartridge().init(rl.getRomData());
        int tile = 0;
        int pattern = 0;
        int i = 4096;
        while (i < 8192) {
            if (pattern >= 0 && pattern < 8) {
                this.logger.debug((Object)("byte " + pattern + " for tile " + tile + ":" + this.getCartridge().getPatternTiles()[i]));
            } else if (pattern >= 8 && pattern < 16) {
                this.logger.debug((Object)("byte " + pattern + " for tile " + tile + ":" + this.getCartridge().getPatternTiles()[i]));
            }
            if (++pattern > 15) {
                ++tile;
                pattern = 0;
            }
            ++i;
        }
        this.getCartridge().getPatternTiles();
    }

    @Test
    public void testImageGenerator() throws Exception {
        RomLoader rl = new RomLoader("./roms/BalloonFight.zip");
        this.getCartridge().init(rl.getRomData());
        TileTestImageViewer t = new TileTestImageViewer(69);
        t.run();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Ines getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Ines cartridge) {
        this.cartridge = cartridge;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

