/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.cartridge.RomLoader;
import com.lambelly.lambnes.util.ArrayUtils;
import java.io.FileNotFoundException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class CartridgeTest {
    private Logger logger = Logger.getLogger(CartridgeTest.class);
    private RomLoader rl = null;
    @Autowired
    private Ines ines;

    @Before
    public void initialize() throws FileNotFoundException {
        this.logger.debug((Object)"loading file");
        this.setRl(new RomLoader("./roms/Wrecking Crew.zip"));
        this.logger.debug((Object)"creating ines");
        this.getInes().init(this.getRl().getRomData());
    }

    @Test
    public void headerControl() throws FileNotFoundException {
        int controlBit1 = 16;
        int controlBit2 = 0;
        this.logger.debug((Object)("controlBit1 & 0xF0: " + (controlBit1 & 0xF0)));
        Assert.assertEquals((long)1L, (long)((controlBit1 & 0xF0) >> 4 | controlBit2 & 0xF0));
    }

    @Test
    public void header() throws FileNotFoundException {
        Assert.assertTrue((boolean)this.getInes().getHeader().isNes());
    }

    @Test
    public void program() throws FileNotFoundException {
        Assert.assertEquals((long)32768L, (long)this.getInes().getProgramInstructions().length);
    }

    @Test
    public void pattern() throws FileNotFoundException {
        Assert.assertEquals((long)8192L, (long)this.getInes().getPatternTiles().length);
    }

    @Test
    public void patternDebug() throws FileNotFoundException {
        this.logger.debug((Object)"pattern tile head: ");
        ArrayUtils.head(this.getInes().getPatternTiles(), 16);
    }

    public RomLoader getRl() {
        return this.rl;
    }

    public void setRl(RomLoader rl) {
        this.rl = rl;
    }

    public Ines getInes() {
        return this.ines;
    }

    public void setInes(Ines ines) {
        this.ines = ines;
    }
}

