/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuADCTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuADCTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void Immediate() {
        int instruction = 105;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)178L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)15L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void ZeroPage() {
        int instruction = 101;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)178L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)15L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void ZeroPageX() {
        int instruction = 117;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)178L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)15L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void Absolute() {
        int instruction = 109;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)179L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)17L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void AbsoluteX() {
        int instruction = 125;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().setX(10);
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)10L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)189L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)27L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void ZeroPageY() {
        int instruction = 121;
        this.getCpu().setY(10);
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)10L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)189L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)27L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void IndexedIndirect() {
        int instruction = 97;
        this.getCpu().setX(10);
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)10L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)188L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)25L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void IndirectIndexed() {
        int instruction = 113;
        this.getCpu().setY(10);
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 255);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)10L, (long)this.getCpu().getAccumulator());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 174);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)188L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 10);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)25L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void test1() throws IOException {
        int instruction = 105;
        this.getCpu().getFlags().resetFlags();
        this.getCpuMemory().setMemoryFromHexAddress(32769, 0);
        this.getTestUtils().performInstruction(instruction, 0);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isOverflow());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }
}

