/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuBITTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuBITTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testZeroPage() {
        int instruction = 36;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 207);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)207L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32770L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isOverflow());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 0);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32772L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 204);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertTrue((this.getCpu().getAccumulator() != 194 ? 1 : 0) != 0);
        Assert.assertEquals((long)204L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32774L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsolute() {
        int instruction = 44;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 207);
        this.logger.debug((Object)("accumulator: " + Integer.toHexString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)207L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32771L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isOverflow());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 0);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertEquals((long)0L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32774L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().performInstruction(instruction, 204);
        this.logger.debug((Object)("accumulator: " + this.getCpu().getAccumulator()));
        this.logger.debug((Object)("bits: " + Integer.toBinaryString(this.getCpu().getAccumulator())));
        Assert.assertTrue((this.getCpu().getAccumulator() != 194 ? 1 : 0) != 0);
        Assert.assertEquals((long)204L, (long)this.getCpu().getAccumulator());
        Assert.assertEquals((long)32777L, (long)this.getCpuMemory().getProgramCounter());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isCarry());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

