/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuDECTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuDECTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testDEX() {
        int instruction = 202;
        this.getCpu().setX(204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpu().getX());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getX());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testDEY() {
        int instruction = 136;
        this.getCpu().setY(204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setY(1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpu().getY());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setY(0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpu().getY());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testDECZeroPage() {
        int instruction = 198;
        this.getTestUtils().setMemory(1, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(3, 1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(3));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(5, 0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getMemoryFromHexAddress(5));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testDECZeroPageX() {
        int instruction = 214;
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(193, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpuMemory().getMemoryFromHexAddress(193));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.logger.debug((Object)"test2");
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(32771, 1);
        this.getTestUtils().setMemory(193, 1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(193));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(67);
        this.getTestUtils().setMemory(72, 0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getMemoryFromHexAddress(72));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsolute() {
        int instruction = 206;
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(513, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpuMemory().getMemoryFromHexAddress(513));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.logger.debug((Object)"test2");
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(1284, 1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(1284));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getTestUtils().setMemory(2055, 0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getMemoryFromHexAddress(2055));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    @Test
    public void testAbsoluteX() {
        int instruction = 222;
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(705, 204);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)203L, (long)this.getCpuMemory().getMemoryFromHexAddress(705));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        this.logger.debug((Object)"test2");
        this.getCpu().setX(192);
        this.getTestUtils().setMemory(1476, 1);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getMemoryFromHexAddress(1476));
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isZero());
        this.getCpu().setX(160);
        this.getTestUtils().setMemory(2215, 0);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getMemoryFromHexAddress(2215));
        Assert.assertTrue((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

