/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuPHATest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuPHATest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testPHA() {
        int instruction = 72;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getTestUtils().performInstruction(instruction, 161);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getStackPointer());
        int result = this.getCpuMemory().popStack();
        Assert.assertEquals((long)161L, (long)result);
    }

    @Test
    public void testPLA() throws IOException {
        int instruction = 104;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpuMemory().pushStack(207);
        this.getTestUtils().performInstruction(instruction, 161);
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getStackPointer());
        Assert.assertEquals((long)207L, (long)this.getCpu().getAccumulator());
    }

    @Test
    public void testPHP() {
        int instruction = 8;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setNegative(true);
        this.getCpu().getFlags().setOverflow(false);
        this.getCpu().getFlags().setDecimalMode(false);
        this.getCpu().getFlags().setIrqDisable(true);
        this.getCpu().getFlags().setZero(false);
        this.getCpu().getFlags().setCarry(true);
        this.getTestUtils().performInstruction(instruction);
        int result = this.getCpuMemory().popStack();
        Assert.assertEquals((long)181L, (long)result);
    }

    @Test
    public void testPHP2() {
        int instruction = 8;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpu().getFlags().setNegative(true);
        this.getCpu().getFlags().setOverflow(true);
        this.getCpu().getFlags().setDecimalMode(false);
        this.getCpu().getFlags().setIrqDisable(true);
        this.getCpu().getFlags().setZero(false);
        this.getCpu().getFlags().setCarry(false);
        this.getTestUtils().performInstruction(instruction);
        int result = this.getCpuMemory().popStack();
        this.logger.debug((Object)("status: 0x" + Integer.toHexString(result)));
        Assert.assertEquals((long)244L, (long)result);
    }

    @Test
    public void testPLP() throws IOException {
        int instruction = 40;
        this.logger.debug((Object)("testing instruction: " + Integer.toHexString(instruction)));
        this.getCpuMemory().pushStack(85);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertFalse((boolean)this.getCpu().getFlags().isNegative());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isOverflow());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isDecimalMode());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isIrqDisable());
        Assert.assertFalse((boolean)this.getCpu().getFlags().isZero());
        Assert.assertTrue((boolean)this.getCpu().getFlags().isCarry());
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

