/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesCpuSTOTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private TestUtils testUtils;
    private Logger logger = Logger.getLogger(NesCpuSTOTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testSTAZeroPage() {
        int instruction = 133;
        this.getCpu().setAccumulator(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
    }

    @Test
    public void testSTAZeroPageX() {
        int instruction = 149;
        this.getCpu().setAccumulator(223);
        this.getCpu().setX(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpuMemory().getMemoryFromHexAddress(27));
    }

    @Test
    public void testSTAAbsolute() {
        int instruction = 141;
        this.getCpu().setAccumulator(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpuMemory().getMemoryFromHexAddress(513));
    }

    @Test
    public void testSTAAbsoluteX() {
        int instruction = 157;
        this.getCpu().setX(26);
        this.getCpu().setAccumulator(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpuMemory().getMemoryFromHexAddress(539));
    }

    @Test
    public void testSTAAbsoluteY() {
        int instruction = 153;
        this.getCpu().setY(26);
        this.getCpu().setAccumulator(223);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)223L, (long)this.getCpuMemory().getMemoryFromHexAddress(539));
    }

    @Test
    public void testSTXZeroPage() {
        int instruction = 134;
        this.getCpu().setX(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
    }

    @Test
    public void testSTXZeroPageY() {
        int instruction = 150;
        this.getCpu().setX(26);
        this.getCpu().setY(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(27));
    }

    @Test
    public void testSTXAbsolute() {
        int instruction = 142;
        this.getCpu().setX(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(513));
    }

    @Test
    public void testSTYZeroPage() {
        int instruction = 132;
        this.getCpu().setY(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(1));
    }

    @Test
    public void testSTYZeroPageX() {
        int instruction = 148;
        this.getCpu().setX(26);
        this.getCpu().setY(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(27));
    }

    @Test
    public void testSTYAbsolute() {
        int instruction = 140;
        this.getCpu().setY(26);
        this.getTestUtils().performInstruction(instruction);
        Assert.assertEquals((long)26L, (long)this.getCpuMemory().getMemoryFromHexAddress(513));
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }
}

