/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuAddressingModes;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import com.lambelly.lambnes.util.BitUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class NesMemoryTest {
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private NesCpuAddressingModes addressingModes;
    @Autowired
    private TestUtils testUtils;
    private static Logger logger = Logger.getLogger(NesMemoryTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void testImmediate() {
        int zero = this.getAddressingModes().getImmediateValue();
        Assert.assertEquals((long)0L, (long)zero);
        Assert.assertEquals((long)32769L, (long)this.getCpuMemory().getProgramCounter());
        int one = this.getAddressingModes().getImmediateValue();
        Assert.assertEquals((long)1L, (long)one);
    }

    @Test
    public void testAbsolute() throws IOException {
        logger.debug((Object)("program counter: " + this.getCpuMemory().getProgramCounter()));
        int test1 = this.getAddressingModes().getAbsoluteValue();
        Assert.assertFalse((10 == test1 ? 1 : 0) != 0);
        Assert.assertFalse((100 == test1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)test1);
        Assert.assertEquals((long)32770L, (long)this.getCpuMemory().getProgramCounter());
        int test2 = this.getAddressingModes().getAbsoluteValue();
        Assert.assertEquals((long)2L, (long)test2);
        this.getCpuMemory().setMemoryFromHexAddress(32772, 254);
        this.getCpuMemory().setMemoryFromHexAddress(32773, 2);
        int test3 = this.getAddressingModes().getAbsoluteValue();
        Assert.assertEquals((long)254L, (long)test3);
    }

    @Test
    public void testAbsoluteX() {
        this.getCpu().setX(192);
        int test1 = this.getAddressingModes().getAbsoluteIndexedXValue();
        Assert.assertEquals((long)192L, (long)test1);
    }

    @Test
    public void testAbsoluteY() {
        this.getCpu().setY(192);
        int test1 = this.getAddressingModes().getAbsoluteIndexedXValue();
        Assert.assertEquals((long)192L, (long)test1);
    }

    @Test
    public void zeroPage() throws IOException {
        int test1 = this.getAddressingModes().getZeroPageValue();
        Assert.assertEquals((long)0L, (long)test1);
        int test2 = this.getAddressingModes().getZeroPageValue();
        Assert.assertEquals((long)1L, (long)test2);
        this.getCpuMemory().setMemoryFromHexAddress(2, 15);
        int test3 = this.getAddressingModes().getZeroPageValue();
        Assert.assertEquals((long)15L, (long)test3);
    }

    @Test
    public void testZeroPageIndexedIndirect() {
        logger.debug((Object)"testing zero page indexed indirect");
        this.getCpu().setX(10);
        int test1 = this.getAddressingModes().getIndexedIndirectXValue();
        Assert.assertEquals((long)10L, (long)test1);
        int test2 = this.getAddressingModes().getIndexedIndirectXValue();
        Assert.assertEquals((long)11L, (long)test2);
    }

    @Test
    public void ZeroPageXIndexed() {
        this.getCpu().setX(3);
        int test1 = this.getAddressingModes().getZeroPageIndexedXValue();
        Assert.assertEquals((long)3L, (long)test1);
        int test2 = this.getAddressingModes().getZeroPageIndexedXValue();
        Assert.assertEquals((long)4L, (long)test2);
        this.getCpu().setX(255);
        int test3 = this.getAddressingModes().getZeroPageIndexedXValue();
        Assert.assertEquals((long)1L, (long)test3);
    }

    @Test
    public void ZeroPageYIndexed() {
        this.getCpu().setY(3);
        int test1 = this.getAddressingModes().getZeroPageIndexedYValue();
        Assert.assertEquals((long)3L, (long)test1);
        int test2 = this.getAddressingModes().getZeroPageIndexedYValue();
        Assert.assertEquals((long)4L, (long)test2);
        this.getCpu().setY(255);
        int test3 = this.getAddressingModes().getZeroPageIndexedYValue();
        Assert.assertEquals((long)1L, (long)test3);
    }

    @Test
    public void RelativeAddress() throws IOException {
        this.getCpuMemory().setProgramCounter(32782);
        this.getCpuMemory().setMemoryFromHexAddress(32782, 251);
        int address = this.getAddressingModes().getRelativeAddress();
        Assert.assertEquals((long)32778L, (long)address);
        logger.debug((Object)("address is now: " + Integer.toHexString(address)));
    }

    @Test
    public void pushStack() throws IOException {
        this.getCpuMemory().pushStack(137);
        Assert.assertEquals((long)255L, (long)this.getCpuMemory().getStackPointer());
        int value = this.getCpuMemory().popStack();
        Assert.assertEquals((long)0L, (long)this.getCpuMemory().getStackPointer());
        Assert.assertEquals((long)137L, (long)value);
        int address = 43981;
        int[] a = BitUtils.splitAddress(address);
        this.getCpuMemory().pushStack(a[1]);
        this.getCpuMemory().pushStack(a[0]);
        Assert.assertEquals((long)205L, (long)this.getCpuMemory().popStack());
        Assert.assertEquals((long)171L, (long)this.getCpuMemory().popStack());
    }

    @Test
    public void readFrom0x2002() {
        logger.debug((Object)this.getCpuMemory().getMemoryFromHexAddress(8194));
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }

    public NesCpuAddressingModes getAddressingModes() {
        return this.addressingModes;
    }

    public void setAddressingModes(NesCpuAddressingModes addressingModes) {
        this.addressingModes = addressingModes;
    }
}

